/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.bash.BashIO;
import io.github.andreyzebin.gitSql.git.VersionControl;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.stream.Stream;

public class GitCommands {
    public static void clone(String target, BashIO bash, PrintStream out, PrintStream err, String uri, boolean isQuiet, Path cd, String authHeader, boolean useSShAgent) {
        String props = isQuiet ? " --quiet" : " ";
        String sshAgent = useSShAgent ? "ssh-add && " : " ";
        bash.runCommand(sshAgent + "git clone -c core.protectNTFS=false " + authHeader + " " + uri + props + " " + target, out, err, cd);
    }

    public static void add(Path repo, BashIO bash, Path relative, PrintStream out, PrintStream err) {
        bash.runCommand("git add " + Bash.escape(Bash.toPosix(relative)), out, err, repo);
    }

    public static void commit(Path repo, BashIO bash, PrintStream out, PrintStream err) {
        bash.runCommand("git commit -a -m \"msg\"", out, err, repo);
    }

    public static void push(Path repo, BashIO bash, PrintStream out, PrintStream err, boolean useSShAgent) {
        String sshAgent = useSShAgent ? "ssh-add && " : " ";
        bash.runCommand(sshAgent + "git push ", out, err, repo);
    }

    public static void checkout(Path repo, String hash, BashIO bash, PrintStream out, PrintStream err, boolean useSShAgent) {
        String sshAgent = useSShAgent ? "ssh-add && " : " ";
        bash.runCommand(sshAgent + "git checkout " + hash, out, err, repo);
    }

    public static Stream<VersionControl.Commit> commitsList(Path repo, BashIO bash, PrintStream err) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bash.runCommand("git --no-pager log --pretty=%cI,%H ", new PrintStream(out), err, repo);
        return out.toString().lines().map(cLine -> VersionControl.Commit.builder().timestamp(cLine.split(",")[0]).hash(cLine.split(",")[1]).build());
    }
}

