/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.FSOffsetProxy;
import io.github.andreyzebin.gitSql.FileSystem;
import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.bash.BashIO;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitCommands;
import io.github.andreyzebin.gitSql.git.GitSource;
import io.github.andreyzebin.gitSql.git.VersionControl;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitFiles
implements FileSystem,
VersionControl {
    private static final Logger log = LoggerFactory.getLogger(GitFiles.class);
    private final BashIO bash;
    private final boolean isReadOnly;
    private final GitAuth authStrategy;
    private final GitSource source;
    private StringBuffer filesToAdd;

    public GitFiles(BashIO bash, boolean isReadOnly, GitAuth authStrategy, GitSource source) {
        this.bash = bash;
        this.isReadOnly = isReadOnly;
        this.authStrategy = authStrategy;
        this.source = source;
        this.filesToAdd = new StringBuffer();
    }

    @Override
    public Writer put(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Bash.append(this.filesToAdd, path.toString());
            return new FileWriter(newFile.toFile(), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getAbs(Path path) {
        return this.source.getRoot().resolve(path);
    }

    @Override
    public boolean erase(Path path) {
        try {
            Path newFile = this.getAbs(path);
            if (Files.exists(newFile, new LinkOption[0])) {
                Files.deleteIfExists(newFile);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Writer patch(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Bash.append(this.filesToAdd, path.toString());
            return new FileWriter(newFile.toFile(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Reader get(Path path) {
        try {
            return new FileReader(this.getAbs(path).toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists(Path path) {
        return this.getAbs(path).toFile().exists();
    }

    @Override
    public boolean isDir(Path path) {
        return this.getAbs(path).toFile().isDirectory();
    }

    @Override
    public String run(String cmd, PrintStream stdOut, PrintStream stdErr, Path path) {
        this.bash.runCommand(cmd, stdOut, stdErr, this.source.getRoot().resolve(path));
        return "";
    }

    @Override
    public void find(Function<Path, Boolean> needContinue, Consumer<Path> sayBye, Comparator<Path> sorting) {
        Path root = this.source.getRoot();
        FileSystem.tVerse(root, p -> (Boolean)needContinue.apply(root.relativize((Path)p)), p -> sayBye.accept(root.relativize((Path)p)), sorting);
    }

    @Override
    public void flush() {
        LogWriter errLog;
        LogWriter outLog;
        if (this.isReadOnly) {
            return;
        }
        Path root = this.source.getRoot();
        if (!this.filesToAdd.toString().isBlank()) {
            Arrays.stream(this.filesToAdd.toString().split(System.lineSeparator())).forEach(cFile -> {
                try (LogWriter outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0));
                     LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0));){
                    GitCommands.add(root, this.bash, Path.of(cFile, new String[0]), outLog.getPS(), errLog.getPS());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        try {
            outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0));
            try {
                errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0));
                try {
                    GitCommands.commit(root, this.bash, outLog.getPS(), errLog.getPS());
                }
                finally {
                    errLog.close();
                }
            }
            finally {
                outLog.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0));
            try {
                errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0));
                try {
                    GitCommands.push(root, this.bash, outLog.getPS(), errLog.getPS(), this.authStrategy.useSshAgent());
                }
                finally {
                    errLog.close();
                }
            }
            finally {
                outLog.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.filesToAdd = new StringBuffer();
    }

    @Override
    public FileSystem cd(Path jump) {
        return new FSOffsetProxy(this, jump);
    }

    @Override
    public GitFiles seek(String commit) {
        try (LogWriter outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0));
             LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0));){
            GitCommands.checkout(this.source.getRoot(), commit, this.bash, outLog.getPS(), errLog.getPS(), this.authStrategy.useSshAgent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public Stream<VersionControl.Commit> commits() {
        Stream<VersionControl.Commit> stream;
        LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0));
        try {
            stream = GitCommands.commitsList(this.source.getRoot(), this.bash, errLog.getPS());
        }
        catch (Throwable throwable) {
            try {
                try {
                    errLog.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        errLog.close();
        return stream;
    }

    @Override
    public Instant timestamp() {
        Instant instant;
        LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0));
        try {
            instant = GitCommands.commitsList(this.source.getRoot(), this.bash, errLog.getPS()).findFirst().get().getTimestampInstant();
        }
        catch (Throwable throwable) {
            try {
                try {
                    errLog.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        errLog.close();
        return instant;
    }

    @Override
    public void close() throws Exception {
        this.flush();
    }

    public static class LogWriter
    implements AutoCloseable {
        private final Consumer<String> logger;
        private final ByteArrayOutputStream bs = new ByteArrayOutputStream();

        public LogWriter(Consumer<String> logger) {
            this.logger = logger;
        }

        public PrintStream getPS() {
            return new PrintStream(this.bs);
        }

        @Override
        public void close() throws Exception {
            String bsString = this.bs.toString();
            boolean blank = bsString.isBlank();
            if (!blank) {
                this.logger.accept(bsString);
            }
        }
    }
}

