/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.pretty;

import io.github.andreyzebin.gitSql.bash.Color;
import io.github.andreyzebin.gitSql.pretty.ResultRenders;
import io.github.andreyzebin.gitSql.pretty.RowRender;
import io.github.andreyzebin.gitSql.pretty.TableComposition;
import io.github.andreyzebin.gitSql.pretty.TablePrinter;
import io.github.andreyzebin.gitSql.pretty.TableStreamRow;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MyTableComposition
implements TableComposition {
    private String horizontalSplitter;
    private String brick;
    private ToIntFunction<Map.Entry<String, Optional<String>>> columnOrder;
    private ToIntFunction<Stream<Map.Entry<String, String>>> indents;
    private boolean headingHorizontalBorders;
    private boolean totalsHorizontalBorders;
    private boolean needAfterRows;
    private String cellSurround;
    private boolean hasTabulation;
    private Function<Map.Entry<String, String>, String> totalsRender;
    private final Function<String, String> nullRender;
    private final Function<String, String> escape;

    public MyTableComposition(String horizontalSplitter, String verticalSplitter, ToIntFunction<Map.Entry<String, Optional<String>>> columnOrder, ToIntFunction<Stream<Map.Entry<String, String>>> indents, boolean headingHorizontalBorders, boolean totalsHorizontalBorders, boolean needAfterRows, String cellSurround, boolean hasTabulation, Function<Map.Entry<String, String>, String> totalsRender, Function<String, String> nullRender, Function<String, String> escape) {
        this.horizontalSplitter = horizontalSplitter;
        this.brick = verticalSplitter;
        this.columnOrder = columnOrder;
        this.indents = indents;
        this.headingHorizontalBorders = headingHorizontalBorders;
        this.totalsHorizontalBorders = totalsHorizontalBorders;
        this.needAfterRows = needAfterRows;
        this.cellSurround = cellSurround;
        this.hasTabulation = hasTabulation;
        this.totalsRender = totalsRender;
        this.nullRender = nullRender;
        this.escape = escape;
    }

    public static MyTableComposition dumpCSV(List<String> rowNumber, String horizontalSplitter, String surround) {
        return new MyTableComposition(horizontalSplitter, "", MyTableComposition.constantOrder(rowNumber), value -> ((String)((Map.Entry)value.findFirst().get()).getValue()).length() + 1, false, false, false, surround, false, ResultRenders.renderValue(), f -> "null", f -> {
            if (!surround.isEmpty()) {
                f = f.replace(surround, surround + surround);
            }
            return f;
        });
    }

    public static MyTableComposition prettyPrint(int defaultWidth, List<AbstractMap.SimpleEntry<String, Integer>> columns) {
        return new MyTableComposition("", "-", MyTableComposition.constantOrder(columns.stream().map(AbstractMap.SimpleEntry::getKey).collect(Collectors.toList())), MyTableComposition.constantWidth(columns.stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)), defaultWidth), true, true, true, "", true, ResultRenders.renderValue(), f -> "null", f -> f);
    }

    public static Consumer<String> println(BufferedWriter br) {
        return cLine -> {
            try {
                br.write((String)cLine);
                br.newLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static ToIntFunction<Stream<Map.Entry<String, String>>> constantWidth(Map<String, Integer> rowNumber, int defaultValue) {
        return a -> {
            String key = a.map(Map.Entry::getKey).reduce((aa, bb) -> aa).get().toLowerCase();
            return rowNumber.getOrDefault(key, defaultValue);
        };
    }

    public static ToIntFunction<Map.Entry<String, Optional<String>>> constantOrder(List<String> cols) {
        return aa -> {
            HashMap colIndexes = new HashMap();
            cols.forEach(key -> colIndexes.put(key.toLowerCase(), colIndexes.size()));
            return Optional.ofNullable((Integer)colIndexes.get(((String)aa.getKey()).toLowerCase())).orElse(Integer.MAX_VALUE);
        };
    }

    private Function<Map<String, Optional<String>>, String> formattedTable() {
        return r -> {
            Stream rowRAW = r.entrySet().stream();
            Map<String, Integer> indents = r.entrySet().stream().map(stringStringEntry -> new AbstractMap.SimpleEntry<String, Integer>(((String)stringStringEntry.getKey()).toLowerCase(), this.indents.applyAsInt(Stream.of(new AbstractMap.SimpleEntry<String, String>((String)stringStringEntry.getKey(), MyTableComposition.renderNullableValue(stringStringEntry, this.nullRender)))))).filter(se -> (Integer)se.getValue() > 0).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
            RowRender rowRender = new RowRender(indents, this.horizontalSplitter, this.cellSurround, this.hasTabulation, this.nullRender, this.escape);
            return rowRAW.sorted(Comparator.comparingInt(this.columnOrder)).collect(rowRender);
        };
    }

    @Override
    public void getAfterRows(TablePrinter tableStream, LinkedList<String> strings) {
        if (this.needAfterRows) {
            this.printTotals(tableStream, this.totalsRender, strings);
        }
    }

    @Override
    public Consumer<TableStreamRow> getRowConsumer(LinkedList<String> strings) {
        return row -> {
            Map<String, Optional<String>> rowWithTotals = row.getRowWithTotals();
            if (!row.getTable().isHeaderPrinted()) {
                int sumWidth = rowWithTotals.entrySet().stream().map(r -> this.indents.applyAsInt(Stream.of(new AbstractMap.SimpleEntry<String, String>((String)r.getKey(), MyTableComposition.renderNullableValue(r, this.nullRender))))).reduce(Integer::sum).get();
                if (this.headingHorizontalBorders) {
                    strings.add(RowRender.fill(sumWidth, this.brick));
                }
                MyTableComposition.printHeading(row, strings, this.formattedTable());
                if (this.headingHorizontalBorders) {
                    strings.add(RowRender.fill(sumWidth, this.brick));
                }
            }
            strings.add(this.formattedTable().apply(rowWithTotals));
        };
    }

    public static String renderNullableValue(Map.Entry<String, Optional<String>> r, Function<String, String> nullRender1) {
        return r.getValue().isEmpty() ? nullRender1.apply(r.getKey()) : r.getValue().get();
    }

    public void printTotals(TablePrinter tableStream, Function<Map.Entry<String, String>, String> totalsRender, LinkedList<String> strings) {
        Integer sumWidth = tableStream.getLast().getRowWithTotals().entrySet().stream().map(r -> this.indents.applyAsInt(Stream.of(new AbstractMap.SimpleEntry<String, String>((String)r.getKey(), MyTableComposition.renderNullableValue(r, this.nullRender))))).reduce(Integer::sum).get();
        if (this.totalsHorizontalBorders) {
            strings.add(RowRender.fill(sumWidth, this.brick));
        }
        Stream totals = tableStream.getLast().getTotals().entrySet().stream();
        strings.add("Total: " + String.valueOf((Object)Color.WHITE_BOLD_BRIGHT) + totals.map(ce -> new AbstractMap.SimpleEntry<String, String>((String)ce.getKey(), ((Integer)ce.getValue()).toString())).map(totalsRender).collect(Collectors.joining(this.brick)) + String.valueOf((Object)Color.RESET));
    }

    private static void printHeading(TableStreamRow row, LinkedList<String> strings, Function<Map<String, Optional<String>>, String> tableRender) {
        Map<String, Optional> heading = TablePrinter.combine(row.getTable().getHeaders(), row.getTotals().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getKey))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, vv -> Optional.ofNullable((String)vv.getValue())));
        strings.add(tableRender.apply(heading));
        row.getTable().setHeaderPrinted(true);
    }

    public static MyTableCompositionBuilder builder() {
        return new MyTableCompositionBuilder();
    }

    public String getHorizontalSplitter() {
        return this.horizontalSplitter;
    }

    public String getBrick() {
        return this.brick;
    }

    public ToIntFunction<Map.Entry<String, Optional<String>>> getColumnOrder() {
        return this.columnOrder;
    }

    public ToIntFunction<Stream<Map.Entry<String, String>>> getIndents() {
        return this.indents;
    }

    public boolean isHeadingHorizontalBorders() {
        return this.headingHorizontalBorders;
    }

    public boolean isTotalsHorizontalBorders() {
        return this.totalsHorizontalBorders;
    }

    public boolean isNeedAfterRows() {
        return this.needAfterRows;
    }

    public String getCellSurround() {
        return this.cellSurround;
    }

    public boolean isHasTabulation() {
        return this.hasTabulation;
    }

    public Function<Map.Entry<String, String>, String> getTotalsRender() {
        return this.totalsRender;
    }

    public Function<String, String> getNullRender() {
        return this.nullRender;
    }

    public Function<String, String> getEscape() {
        return this.escape;
    }

    public void setHorizontalSplitter(String horizontalSplitter) {
        this.horizontalSplitter = horizontalSplitter;
    }

    public void setBrick(String brick) {
        this.brick = brick;
    }

    public void setColumnOrder(ToIntFunction<Map.Entry<String, Optional<String>>> columnOrder) {
        this.columnOrder = columnOrder;
    }

    public void setIndents(ToIntFunction<Stream<Map.Entry<String, String>>> indents) {
        this.indents = indents;
    }

    public void setHeadingHorizontalBorders(boolean headingHorizontalBorders) {
        this.headingHorizontalBorders = headingHorizontalBorders;
    }

    public void setTotalsHorizontalBorders(boolean totalsHorizontalBorders) {
        this.totalsHorizontalBorders = totalsHorizontalBorders;
    }

    public void setNeedAfterRows(boolean needAfterRows) {
        this.needAfterRows = needAfterRows;
    }

    public void setCellSurround(String cellSurround) {
        this.cellSurround = cellSurround;
    }

    public void setHasTabulation(boolean hasTabulation) {
        this.hasTabulation = hasTabulation;
    }

    public void setTotalsRender(Function<Map.Entry<String, String>, String> totalsRender) {
        this.totalsRender = totalsRender;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MyTableComposition)) {
            return false;
        }
        MyTableComposition other = (MyTableComposition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHeadingHorizontalBorders() != other.isHeadingHorizontalBorders()) {
            return false;
        }
        if (this.isTotalsHorizontalBorders() != other.isTotalsHorizontalBorders()) {
            return false;
        }
        if (this.isNeedAfterRows() != other.isNeedAfterRows()) {
            return false;
        }
        if (this.isHasTabulation() != other.isHasTabulation()) {
            return false;
        }
        String this$horizontalSplitter = this.getHorizontalSplitter();
        String other$horizontalSplitter = other.getHorizontalSplitter();
        if (this$horizontalSplitter == null ? other$horizontalSplitter != null : !this$horizontalSplitter.equals(other$horizontalSplitter)) {
            return false;
        }
        String this$brick = this.getBrick();
        String other$brick = other.getBrick();
        if (this$brick == null ? other$brick != null : !this$brick.equals(other$brick)) {
            return false;
        }
        ToIntFunction<Map.Entry<String, Optional<String>>> this$columnOrder = this.getColumnOrder();
        ToIntFunction<Map.Entry<String, Optional<String>>> other$columnOrder = other.getColumnOrder();
        if (this$columnOrder == null ? other$columnOrder != null : !this$columnOrder.equals(other$columnOrder)) {
            return false;
        }
        ToIntFunction<Stream<Map.Entry<String, String>>> this$indents = this.getIndents();
        ToIntFunction<Stream<Map.Entry<String, String>>> other$indents = other.getIndents();
        if (this$indents == null ? other$indents != null : !this$indents.equals(other$indents)) {
            return false;
        }
        String this$cellSurround = this.getCellSurround();
        String other$cellSurround = other.getCellSurround();
        if (this$cellSurround == null ? other$cellSurround != null : !this$cellSurround.equals(other$cellSurround)) {
            return false;
        }
        Function<Map.Entry<String, String>, String> this$totalsRender = this.getTotalsRender();
        Function<Map.Entry<String, String>, String> other$totalsRender = other.getTotalsRender();
        if (this$totalsRender == null ? other$totalsRender != null : !this$totalsRender.equals(other$totalsRender)) {
            return false;
        }
        Function<String, String> this$nullRender = this.getNullRender();
        Function<String, String> other$nullRender = other.getNullRender();
        if (this$nullRender == null ? other$nullRender != null : !this$nullRender.equals(other$nullRender)) {
            return false;
        }
        Function<String, String> this$escape = this.getEscape();
        Function<String, String> other$escape = other.getEscape();
        return !(this$escape == null ? other$escape != null : !this$escape.equals(other$escape));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MyTableComposition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHeadingHorizontalBorders() ? 79 : 97);
        result = result * 59 + (this.isTotalsHorizontalBorders() ? 79 : 97);
        result = result * 59 + (this.isNeedAfterRows() ? 79 : 97);
        result = result * 59 + (this.isHasTabulation() ? 79 : 97);
        String $horizontalSplitter = this.getHorizontalSplitter();
        result = result * 59 + ($horizontalSplitter == null ? 43 : $horizontalSplitter.hashCode());
        String $brick = this.getBrick();
        result = result * 59 + ($brick == null ? 43 : $brick.hashCode());
        ToIntFunction<Map.Entry<String, Optional<String>>> $columnOrder = this.getColumnOrder();
        result = result * 59 + ($columnOrder == null ? 43 : $columnOrder.hashCode());
        ToIntFunction<Stream<Map.Entry<String, String>>> $indents = this.getIndents();
        result = result * 59 + ($indents == null ? 43 : $indents.hashCode());
        String $cellSurround = this.getCellSurround();
        result = result * 59 + ($cellSurround == null ? 43 : $cellSurround.hashCode());
        Function<Map.Entry<String, String>, String> $totalsRender = this.getTotalsRender();
        result = result * 59 + ($totalsRender == null ? 43 : $totalsRender.hashCode());
        Function<String, String> $nullRender = this.getNullRender();
        result = result * 59 + ($nullRender == null ? 43 : $nullRender.hashCode());
        Function<String, String> $escape = this.getEscape();
        result = result * 59 + ($escape == null ? 43 : $escape.hashCode());
        return result;
    }

    public String toString() {
        return "MyTableComposition(horizontalSplitter=" + this.getHorizontalSplitter() + ", brick=" + this.getBrick() + ", columnOrder=" + String.valueOf(this.getColumnOrder()) + ", indents=" + String.valueOf(this.getIndents()) + ", headingHorizontalBorders=" + this.isHeadingHorizontalBorders() + ", totalsHorizontalBorders=" + this.isTotalsHorizontalBorders() + ", needAfterRows=" + this.isNeedAfterRows() + ", cellSurround=" + this.getCellSurround() + ", hasTabulation=" + this.isHasTabulation() + ", totalsRender=" + String.valueOf(this.getTotalsRender()) + ", nullRender=" + String.valueOf(this.getNullRender()) + ", escape=" + String.valueOf(this.getEscape()) + ")";
    }

    public MyTableComposition withHorizontalSplitter(String horizontalSplitter) {
        return this.horizontalSplitter == horizontalSplitter ? this : new MyTableComposition(horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.cellSurround, this.hasTabulation, this.totalsRender, this.nullRender, this.escape);
    }

    public MyTableComposition withBrick(String brick) {
        return this.brick == brick ? this : new MyTableComposition(this.horizontalSplitter, brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.cellSurround, this.hasTabulation, this.totalsRender, this.nullRender, this.escape);
    }

    public MyTableComposition withColumnOrder(ToIntFunction<Map.Entry<String, Optional<String>>> columnOrder) {
        return this.columnOrder == columnOrder ? this : new MyTableComposition(this.horizontalSplitter, this.brick, columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.cellSurround, this.hasTabulation, this.totalsRender, this.nullRender, this.escape);
    }

    public MyTableComposition withIndents(ToIntFunction<Stream<Map.Entry<String, String>>> indents) {
        return this.indents == indents ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.cellSurround, this.hasTabulation, this.totalsRender, this.nullRender, this.escape);
    }

    public MyTableComposition withHeadingHorizontalBorders(boolean headingHorizontalBorders) {
        return this.headingHorizontalBorders == headingHorizontalBorders ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.cellSurround, this.hasTabulation, this.totalsRender, this.nullRender, this.escape);
    }

    public MyTableComposition withTotalsHorizontalBorders(boolean totalsHorizontalBorders) {
        return this.totalsHorizontalBorders == totalsHorizontalBorders ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, totalsHorizontalBorders, this.needAfterRows, this.cellSurround, this.hasTabulation, this.totalsRender, this.nullRender, this.escape);
    }

    public MyTableComposition withNeedAfterRows(boolean needAfterRows) {
        return this.needAfterRows == needAfterRows ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, needAfterRows, this.cellSurround, this.hasTabulation, this.totalsRender, this.nullRender, this.escape);
    }

    public MyTableComposition withCellSurround(String cellSurround) {
        return this.cellSurround == cellSurround ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, cellSurround, this.hasTabulation, this.totalsRender, this.nullRender, this.escape);
    }

    public MyTableComposition withHasTabulation(boolean hasTabulation) {
        return this.hasTabulation == hasTabulation ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.cellSurround, hasTabulation, this.totalsRender, this.nullRender, this.escape);
    }

    public MyTableComposition withTotalsRender(Function<Map.Entry<String, String>, String> totalsRender) {
        return this.totalsRender == totalsRender ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.cellSurround, this.hasTabulation, totalsRender, this.nullRender, this.escape);
    }

    public MyTableComposition withNullRender(Function<String, String> nullRender) {
        return this.nullRender == nullRender ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.cellSurround, this.hasTabulation, this.totalsRender, nullRender, this.escape);
    }

    public MyTableComposition withEscape(Function<String, String> escape) {
        return this.escape == escape ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.cellSurround, this.hasTabulation, this.totalsRender, this.nullRender, escape);
    }

    public static class MyTableCompositionBuilder {
        private String horizontalSplitter;
        private String brick;
        private ToIntFunction<Map.Entry<String, Optional<String>>> columnOrder;
        private ToIntFunction<Stream<Map.Entry<String, String>>> indents;
        private boolean headingHorizontalBorders;
        private boolean totalsHorizontalBorders;
        private boolean needAfterRows;
        private String cellSurround;
        private boolean hasTabulation;
        private Function<Map.Entry<String, String>, String> totalsRender;
        private Function<String, String> nullRender;
        private Function<String, String> escape;

        MyTableCompositionBuilder() {
        }

        public MyTableCompositionBuilder horizontalSplitter(String horizontalSplitter) {
            this.horizontalSplitter = horizontalSplitter;
            return this;
        }

        public MyTableCompositionBuilder brick(String brick) {
            this.brick = brick;
            return this;
        }

        public MyTableCompositionBuilder columnOrder(ToIntFunction<Map.Entry<String, Optional<String>>> columnOrder) {
            this.columnOrder = columnOrder;
            return this;
        }

        public MyTableCompositionBuilder indents(ToIntFunction<Stream<Map.Entry<String, String>>> indents) {
            this.indents = indents;
            return this;
        }

        public MyTableCompositionBuilder headingHorizontalBorders(boolean headingHorizontalBorders) {
            this.headingHorizontalBorders = headingHorizontalBorders;
            return this;
        }

        public MyTableCompositionBuilder totalsHorizontalBorders(boolean totalsHorizontalBorders) {
            this.totalsHorizontalBorders = totalsHorizontalBorders;
            return this;
        }

        public MyTableCompositionBuilder needAfterRows(boolean needAfterRows) {
            this.needAfterRows = needAfterRows;
            return this;
        }

        public MyTableCompositionBuilder cellSurround(String cellSurround) {
            this.cellSurround = cellSurround;
            return this;
        }

        public MyTableCompositionBuilder hasTabulation(boolean hasTabulation) {
            this.hasTabulation = hasTabulation;
            return this;
        }

        public MyTableCompositionBuilder totalsRender(Function<Map.Entry<String, String>, String> totalsRender) {
            this.totalsRender = totalsRender;
            return this;
        }

        public MyTableCompositionBuilder nullRender(Function<String, String> nullRender) {
            this.nullRender = nullRender;
            return this;
        }

        public MyTableCompositionBuilder escape(Function<String, String> escape) {
            this.escape = escape;
            return this;
        }

        public MyTableComposition build() {
            return new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.cellSurround, this.hasTabulation, this.totalsRender, this.nullRender, this.escape);
        }

        public String toString() {
            return "MyTableComposition.MyTableCompositionBuilder(horizontalSplitter=" + this.horizontalSplitter + ", brick=" + this.brick + ", columnOrder=" + String.valueOf(this.columnOrder) + ", indents=" + String.valueOf(this.indents) + ", headingHorizontalBorders=" + this.headingHorizontalBorders + ", totalsHorizontalBorders=" + this.totalsHorizontalBorders + ", needAfterRows=" + this.needAfterRows + ", cellSurround=" + this.cellSurround + ", hasTabulation=" + this.hasTabulation + ", totalsRender=" + String.valueOf(this.totalsRender) + ", nullRender=" + String.valueOf(this.nullRender) + ", escape=" + String.valueOf(this.escape) + ")";
        }
    }
}

