/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.GitFS;
import io.github.andreyzebin.gitSql.git.VersionControl;
import io.github.andreyzebin.gitSql.sql.CommitsIndex;
import io.github.andreyzebin.gitSql.sql.FilesIndex;
import io.github.andreyzebin.gitSql.sql.JdbcView;
import io.github.andreyzebin.gitSql.sql.PersistedDb;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesQuery
extends PersistedDb {
    private static final Logger log = LoggerFactory.getLogger(TimeSeriesQuery.class);
    private static final String COLUMN_NAME_POINT = "ts_point";
    private static final String COLUMN_NAME_HASH = "ts_hash";
    private static final String TABLE_NAME_RESULT = "result";
    private final GitFS dataSet;
    private final JdbcView dataSetView;
    private final Instant from;
    private final Instant to;
    private final String sql;
    private final List<String> resultAliases = new LinkedList<String>();

    public TimeSeriesQuery(String sql, GitFS dataSet, Instant from, Instant to, BiFunction<? super GitFS, Path, ? extends JdbcView> indexerFactory) {
        super(Path.of("run", "tsq_result"));
        this.dataSet = dataSet;
        this.dataSetView = indexerFactory.apply(dataSet, Path.of("run", "tsq_dataset"));
        this.from = from;
        this.to = to;
        this.sql = sql;
    }

    @Override
    protected void createSchema() throws SQLException {
    }

    @Override
    protected void reindex() {
        Connection connection = this.getConnection();
        Iterator commitsAll = this.dataSet.commits().collect(Collectors.toList()).reversed().iterator();
        List<Instant> points = TimeSeriesQuery.rangeSplit(this.from, this.to).toList();
        VersionControl.Commit cCommitPrev = (VersionControl.Commit)commitsAll.next();
        VersionControl.Commit cCommitAfter = (VersionControl.Commit)commitsAll.next();
        HashSet<VersionControl.Commit> commits = new HashSet<VersionControl.Commit>();
        for (Instant cPoint : points) {
            long distPrev = TimeSeriesQuery.getMilliDistance(cCommitPrev.getTimestampInstant(), cPoint);
            long distAfter = TimeSeriesQuery.getMilliDistance(cCommitAfter.getTimestampInstant(), cPoint);
            while (distPrev > distAfter && commitsAll.hasNext()) {
                cCommitPrev = cCommitAfter;
                cCommitAfter = (VersionControl.Commit)commitsAll.next();
                distPrev = TimeSeriesQuery.getMilliDistance(cCommitPrev.getTimestampInstant(), cPoint);
                distAfter = TimeSeriesQuery.getMilliDistance(cCommitAfter.getTimestampInstant(), cPoint);
            }
            VersionControl.Commit bestHit = distPrev < distAfter ? cCommitPrev : cCommitAfter;
            if (!commits.add(bestHit)) continue;
            this.pullCommit(bestHit, connection);
        }
    }

    private void pullCommit(VersionControl.Commit cCommitPrev, Connection connection) {
        this.dataSet.seek(cCommitPrev.getHash());
        this.dataSetView.drop();
        FilesIndex.streamRows(rs -> {
            boolean needFillHeader = this.resultAliases.isEmpty();
            if (needFillHeader) {
                this.resultAliases.add(COLUMN_NAME_POINT);
                this.resultAliases.add(COLUMN_NAME_HASH);
            }
            LinkedList<String> row = new LinkedList<String>();
            row.add(cCommitPrev.getTimestampInstant().toString());
            row.add(cCommitPrev.getHash());
            FilesIndex.streamFields(rs).forEach(cColumn -> {
                if (needFillHeader) {
                    this.resultAliases.add((String)cColumn.getKey());
                }
                row.add((String)cColumn.getValue());
            });
            LinkedList<String> rov = new LinkedList<String>(this.resultAliases);
            rov.addAll(row);
            return rov;
        }, FilesIndex.query(this.dataSetView.getConnection(), this.sql, new String[0])).forEach(cRow -> {
            this.createSchema2();
            FilesIndex.merge(connection, TABLE_NAME_RESULT, (String[])cRow.toArray(String[]::new));
        });
    }

    private void createSchema2() {
        if (this.schemaCreated) {
            return;
        }
        if (this.storeExists()) {
            try (Statement dml = this.getConnection().createStatement();){
                StringBuilder sql1 = new StringBuilder(String.format("CREATE TABLE IF NOT EXISTS %s\n(\nts_ID INT auto_increment,\n", TABLE_NAME_RESULT));
                for (int i = 0; i < this.resultAliases.size(); ++i) {
                    sql1.append(this.resultAliases.get(i)).append(" VARCHAR(256) ");
                    if (i + 1 < this.resultAliases.size()) {
                        sql1.append(", \n");
                        continue;
                    }
                    sql1.append(" \n");
                }
                sql1.append(");");
                log.debug(CommitsIndex.renderSqlLog(sql1.toString()));
                dml.execute(sql1.toString());
                super.createSchema();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Stream<Instant> rangeSplit(Instant from, Instant to) {
        long milliDelta = TimeSeriesQuery.getMilliDelta(from, to);
        int TIME_PIECES = 10;
        long step = milliDelta / 10L;
        return Stream.iterate(from, i -> i.plusMillis(step)).limit(11L);
    }

    private static long getMilliDelta(Instant start, Instant finish) {
        return finish.toEpochMilli() - start.toEpochMilli();
    }

    private static long getMilliDistance(Instant a, Instant b) {
        return Math.abs(TimeSeriesQuery.getMilliDelta(a, b));
    }
}

