/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public interface FileSystem
extends AutoCloseable {
    public static <T> T loadYaml(Reader strings, Class<T> clazz) {
        LoaderOptions lo = new LoaderOptions();
        lo.setTagInspector(tag -> true);
        Representer r = new Representer(new DumperOptions());
        r.getPropertyUtils().setSkipMissingProperties(true);
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(clazz, lo), r);
        return (T)yaml.load(FileSystem.loadFile(strings));
    }

    private static String loadFile(Reader strings) {
        String string;
        BufferedReader br = new BufferedReader(strings);
        try {
            string = br.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        br.close();
        return string;
    }

    public static <T> void dumpYaml(T meta, Writer dest) {
        DumperOptions op = new DumperOptions();
        Yaml yaml = new Yaml(new Representer(op));
        try (BufferedWriter bw = new BufferedWriter(dest);){
            yaml.dump(meta, (Writer)bw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readJson(Reader r, TypeReference<T> tr) {
        String json = FileSystem.loadFile(r);
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object java = null;
        try {
            java = mapper.readValue(json, tr);
            return (T)java;
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<String> readLines(Reader r) {
        return FileSystem.loadFile(r).lines();
    }

    public static <T> Reader toJson(T value) {
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String java = null;
        try {
            java = mapper.writeValueAsString(value);
            return new InputStreamReader(new ByteArrayInputStream(java.getBytes(StandardCharsets.UTF_8)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void pipe(Reader source, Writer dest) {
        try (BufferedWriter bw = new BufferedWriter(dest);
             BufferedReader br = new BufferedReader(source);){
            br.lines().forEach(cLine -> {
                try {
                    bw.write((String)cLine);
                    bw.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Writer put(Path var1);

    public boolean erase(Path var1);

    public Writer patch(Path var1);

    public Reader get(Path var1);

    public boolean exists(Path var1);

    public boolean isDir(Path var1);

    public String run(String var1, PrintStream var2, PrintStream var3, Path var4);

    public void find(Function<Path, Boolean> var1, Consumer<Path> var2, Comparator<Path> var3);

    default public void find(Function<Path, Boolean> needContinue) {
        this.find(needContinue, p -> {}, FileSystem.filesFirst());
    }

    public static Comparator<Path> filesFirst() {
        return (o1, o2) -> {
            int f1 = Files.isRegularFile(o1, new LinkOption[0]) ? 1 : 0;
            int f2 = Files.isRegularFile(o2, new LinkOption[0]) ? 1 : 0;
            return f2 - f1;
        };
    }

    public void flush();

    public FileSystem cd(Path var1);

    public static void tVerse(Path dir, Function<Path, Boolean> needContinue, Consumer<Path> sayBye, Comparator<Path> sorting) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try {
                List<Path> sorted = Files.list(dir).sorted(sorting).toList();
                for (Path cFile : sorted) {
                    Boolean isContinue = needContinue.apply(cFile);
                    if (Files.isDirectory(cFile, new LinkOption[0]) && isContinue.booleanValue()) {
                        FileSystem.tVerse(cFile, needContinue, sayBye, sorting);
                        sayBye.accept(cFile);
                        continue;
                    }
                    if (isContinue.booleanValue()) continue;
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

