/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql;

import io.github.andreyzebin.gitSql.FileSystem;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GitDb
implements AutoCloseable {
    private final FileSystem fileSystem;
    private final Path storeDir;
    private Connection connection;
    private final Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers;
    public static final Map<Function<String, Boolean>, BiFunction<String, Reader, String>> JSON_MAPPERS = Map.of(f -> f.endsWith(".json"), (f, r) -> FileSystem.readLines(r).collect(Collectors.joining(System.lineSeparator())));

    public GitDb(FileSystem fileSystem, Path storeDir, Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers) {
        this.fileSystem = fileSystem;
        this.storeDir = storeDir;
        this.mappers = mappers;
    }

    public Connection getConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            Files.createDirectories(this.storeDir, new FileAttribute[0]);
            String jdbcURL = "jdbc:h2:" + String.valueOf(this.storeDir.resolve("data"));
            this.connection = DriverManager.getConnection(jdbcURL, "", "");
            System.out.println("Connected to H2 embedded database.");
            try (Statement dml = this.connection.createStatement();){
                dml.execute("CREATE TABLE IF NOT EXISTS files (ID INT auto_increment, path VARCHAR(256) NOT NULL, data JSON NOT NULL, UNIQUE NULLS ALL DISTINCT (path) );");
            }
            return this.connection;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void reindex() {
        try (Statement dml = this.getConnection().createStatement();){
            this.fileSystem.find(p -> {
                if (!this.fileSystem.isDir((Path)p)) {
                    String fileName = p.getFileName().toString();
                    this.mappers.entrySet().stream().filter(cKey -> (Boolean)((Function)cKey.getKey()).apply(fileName)).findFirst().ifPresent(cF -> GitDb.merge(dml, p.toString(), (String)((BiFunction)cF.getValue()).apply(fileName, this.fileSystem.get((Path)p))));
                }
                return true;
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Stream<T> query(String sql, Function<ResultSet, T> conv, Statement dml) {
        try {
            ResultSet resultSet = dml.executeQuery(sql);
            int count = 0;
            LinkedList<T> result = new LinkedList<T>();
            while (resultSet.next()) {
                ++count;
                result.add(conv.apply(resultSet));
            }
            return result.stream();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void merge(Statement dml, String path, String json) {
        String sql = String.format("   merge into files\n   using values ('%s', JSON '%s') as incoming(path, data)\n   on files.path = incoming.path\n   when not matched then\n       insert (path, data) values (incoming.path, incoming.data)\n   when matched then\n       update set data = incoming.data;\n", path, json);
        System.out.println(sql);
        try {
            dml.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }
}

