/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.pretty;

import io.github.andreyzebin.gitSql.pretty.MyTableComposition;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RowRender
implements Collector<Map.Entry<String, Optional<String>>, List<String>, String> {
    private final Map<String, Integer> colNames;
    private final String delimiter;
    private final String cellSurround;
    private final boolean hasTabulation;
    private final Function<String, String> nullRender;
    private final Function<String, String> escape;

    public RowRender(Map<String, Integer> colNames, String delimiter, String cellSurround, boolean hasTabulation, Function<String, String> nullRender, Function<String, String> escape) {
        this.colNames = colNames;
        this.delimiter = delimiter;
        this.cellSurround = cellSurround;
        this.hasTabulation = hasTabulation;
        this.nullRender = nullRender;
        this.escape = escape;
    }

    @Override
    public Supplier<List<String>> supplier() {
        return LinkedList::new;
    }

    @Override
    public BiConsumer<List<String>, Map.Entry<String, Optional<String>>> accumulator() {
        return (a, b) -> {
            if (this.colNames.containsKey(((String)b.getKey()).toLowerCase())) {
                a.add(this.prepareCell((Map.Entry<String, Optional<String>>)b));
            }
        };
    }

    @Override
    public BinaryOperator<List<String>> combiner() {
        return (a, b) -> {
            a.addAll(b);
            return a;
        };
    }

    @Override
    public Function<List<String>, String> finisher() {
        return a -> {
            StringJoiner stringJoiner = new StringJoiner(this.delimiter);
            a.forEach(stringJoiner::add);
            return stringJoiner.toString();
        };
    }

    private String prepareCell(Map.Entry<String, Optional<String>> cell) {
        Optional<String> value = cell.getValue();
        Object rValue = MyTableComposition.renderNullableValue(cell, this.nullRender);
        if (this.hasTabulation) {
            Integer maxWidth = this.colNames.get(cell.getKey().toLowerCase());
            value = cell.getValue();
            if (((String)rValue).length() > maxWidth - 1 - this.cellSurround.length() * 2) {
                rValue = ((String)rValue).substring(0, maxWidth - 4) + "...";
            }
            rValue = (String)rValue + RowRender.fill(maxWidth - ((String)rValue).length(), " ");
        }
        rValue = this.escape.apply((String)rValue);
        rValue = this.cellSurround + (String)rValue + this.cellSurround;
        return rValue;
    }

    public static String fill(int length, String brick) {
        return Stream.generate(() -> brick).limit(length).collect(Collectors.joining());
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Set.of();
    }
}

