/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.FileSystem;
import io.github.andreyzebin.gitSql.sql.CommitsIndex;
import io.github.andreyzebin.gitSql.sql.PersistedDb;
import java.io.Reader;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesIndex
extends PersistedDb {
    private static final Logger log = LoggerFactory.getLogger(FilesIndex.class);
    private final FileSystem fileSystem;
    private final Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers;
    public static final Map<Function<String, Boolean>, BiFunction<String, Reader, String>> JSON_MAPPERS = Map.of(f -> f.endsWith(".json"), (f, r) -> FileSystem.readLines(r).collect(Collectors.joining(System.lineSeparator())));

    public FilesIndex(FileSystem fileSystem, Path storeDir, Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers) {
        super(storeDir);
        this.fileSystem = fileSystem;
        this.mappers = mappers;
    }

    public static FilesIndex of(FileSystem fileSystem, Path storeDir, Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers) {
        return new FilesIndex(fileSystem, storeDir, mappers);
    }

    public static BiFunction<FileSystem, Path, FilesIndex> of(Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers) {
        return (a, b) -> new FilesIndex((FileSystem)a, (Path)b, mappers);
    }

    @Override
    protected void createSchema() throws SQLException {
        try (Statement dml = this.getConnection().createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS files\n(\n    ID      INT          auto_increment,\n    path    VARCHAR(256) NOT NULL,\n    data    JSON         NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (path)\n);";
            log.debug(CommitsIndex.renderSqlLog("CREATE TABLE IF NOT EXISTS files\n(\n    ID      INT          auto_increment,\n    path    VARCHAR(256) NOT NULL,\n    data    JSON         NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (path)\n);"));
            dml.execute("CREATE TABLE IF NOT EXISTS files\n(\n    ID      INT          auto_increment,\n    path    VARCHAR(256) NOT NULL,\n    data    JSON         NOT NULL,\n    UNIQUE NULLS ALL DISTINCT (path)\n);");
        }
        super.createSchema();
    }

    @Override
    protected void reindex() {
        try {
            this.fileSystem.find(p -> {
                if (!this.fileSystem.isDir((Path)p)) {
                    String fileName = p.getFileName().toString();
                    this.mappers.entrySet().stream().filter(cKey -> (Boolean)((Function)cKey.getKey()).apply(fileName)).findFirst().ifPresent(cF -> FilesIndex.merge(this.getConnection(), "files", "path", "data FORMAT JSON", p.toString(), (String)((BiFunction)cF.getValue()).apply(fileName, this.fileSystem.get((Path)p))));
                }
                return true;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Stream<T> streamRows(Function<ResultSet, T> conv, ResultSet resultSet) {
        try {
            int count = 0;
            LinkedList<T> result = new LinkedList<T>();
            while (resultSet.next()) {
                ++count;
                result.add(conv.apply(resultSet));
            }
            return result.stream();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<Map.Entry<String, String>> streamFields(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            LinkedList<AbstractMap.SimpleEntry<String, String>> all = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
            for (int i = 1; i <= columnCount; ++i) {
                String name = rsmd.getColumnName(i);
                all.add(new AbstractMap.SimpleEntry<String, String>(name, rs.getString(name)));
            }
            return all.stream();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static int merge(Connection con, String tableAlias, String ... values) {
        int n;
        block11: {
            int length = values.length / 2;
            StringJoiner joiner = new StringJoiner(",");
            for (int i = 1; i < length; ++i) {
                String s = String.format(" %s = incoming.%s", FilesIndex.escapeFormat(values[i]), FilesIndex.escapeFormat(values[i]));
                joiner.add(s);
            }
            LinkedList<String> wds = new LinkedList<String>();
            for (int i = 0; i < length; ++i) {
                wds.add(values[i].contains("FORMAT JSON") ? "? FORMAT JSON" : "?");
            }
            String sql = "MERGE    into $table\nUSING    values ($values) as incoming($fields)\nON       $table.$conflictField = incoming.$conflictField\nWHEN not matched then\nINSERT\n    ($fields)\n    values\n    ($Inc.fields)\nWHEN     matched then\nUPDATE\nSET\n    $sets;\n".replace("$table", tableAlias).replace("$values", String.join((CharSequence)",", wds)).replace("$fields", ((Stream)Arrays.stream(values).sequential()).map(FilesIndex::escapeFormat).limit(length).collect(Collectors.joining(","))).replace("$Inc.fields", ((Stream)Arrays.stream(values).sequential()).map(FilesIndex::escapeFormat).limit(length).map(cF -> "incoming." + cF).collect(Collectors.joining(","))).replace("$conflictField", FilesIndex.escapeFormat(values[0])).replace("$sets", joiner.toString());
            PreparedStatement statement = con.prepareStatement(sql);
            try {
                StringBuilder s = new StringBuilder(sql);
                for (int i = 0; i < length; ++i) {
                    int parameterIndex = i + 1;
                    String value = FilesIndex.escapeFormat(values[i + length]);
                    statement.setString(parameterIndex, value);
                    s.append(parameterIndex).append(" = ").append(value).append(System.lineSeparator());
                }
                log.debug(CommitsIndex.renderSqlLog(s.toString()));
                n = statement.executeUpdate();
                if (statement == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return n;
    }

    private static String escapeFormat(String values) {
        return values.replace(" FORMAT JSON", "");
    }

    public static ResultSet query(Connection con, String sql, String ... values) {
        PreparedStatement statement = null;
        try {
            statement = con.prepareStatement(sql);
            log.debug(CommitsIndex.renderSqlLog(sql));
            for (int i = 0; i < values.length; ++i) {
                statement.setString(i + 1, values[i]);
            }
            return statement.executeQuery();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static int queryUpdate(Connection con, String sql, String ... values) {
        int n;
        block9: {
            PreparedStatement statement = con.prepareStatement(sql);
            try {
                log.debug(CommitsIndex.renderSqlLog(sql));
                for (int i = 0; i < values.length; ++i) {
                    statement.setString(i + 1, values[i]);
                }
                n = statement.executeUpdate();
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return n;
    }
}

