package io.github.andreyzebin.gitSql.git;

public interface GitAuth {


    String getAuthHeader();
    boolean useSshAgent();

    static GitAuth ofSshAgent() {
        return new GitAuth() {
            @Override
            public String getAuthHeader() {
                return "";
            }

            @Override
            public boolean useSshAgent() {
                return true;
            }
        };
    }

    static GitAuth ofApiToken(String token) {
        return new GitAuth() {
            @Override
            public String getAuthHeader() {
                return String.format("-c http.extraHeader='Authorization: Bearer %s'", token);
            }

            @Override
            public boolean useSshAgent() {
                return false;
            }
        };
    }
}
