package io.github.andreyzebin.gitSql.git;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.stream.Stream;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

public interface VersionControl {

    @Builder
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    class Commit {

        private String hash;
        private String timestamp;

        @JsonIgnore
        public Instant getTimestampInstant() {
            return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(timestamp));
        }
    }

    VersionControl seek(String commit);

    Stream<? extends Commit> commits();

    Instant timestamp();
}
