package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.VersionControl;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class CommitsIndex extends PersistedDb {

    private final VersionControl git;

    public CommitsIndex(
            VersionControl git,
            Path storeDir
    ) {
        super(storeDir);
        this.git = git;
    }

    @Override
    protected void createSchema() throws SQLException {
        try (Statement dml = getConnection().createStatement();) {
            final String sql = """
                    CREATE TABLE IF NOT EXISTS commits
                    (
                        ID INT auto_increment,
                        hash VARCHAR(256) NOT NULL,
                        timestamp timestamp NOT NULL,
                        UNIQUE NULLS ALL DISTINCT (hash)
                    );""";

            log.debug(renderSqlLog(sql));
            dml.execute(sql);
        }
        super.createSchema();
    }

    public static String renderSqlLog(String sql) {
        return System.lineSeparator() +
                "---" +
                System.lineSeparator() +
                sql.lines()
                        .map(SqlCSS::sqlRender)
                        .collect(Collectors.joining(System.lineSeparator())) +
                System.lineSeparator() +
                "---";
    }

    @Override
    protected void reindex() {
        try {
            git.commits().forEach(
                    cF -> FilesIndex.merge(
                            getConnection(),
                            "commits",
                            "hash",
                            "timestamp",
                            cF.getHash(),
                            cF.getTimestamp()
                    )
            );

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
