/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

public interface GitAuth {
    public String getAuthHeader();

    public boolean useSshAgent();

    public static GitAuth ofSshAgent() {
        return new GitAuth(){

            @Override
            public String getAuthHeader() {
                return "";
            }

            @Override
            public boolean useSshAgent() {
                return true;
            }
        };
    }

    public static GitAuth ofApiToken(final String token) {
        return new GitAuth(){

            @Override
            public String getAuthHeader() {
                return String.format("-c http.extraHeader='Authorization: Bearer %s'", token);
            }

            @Override
            public boolean useSshAgent() {
                return false;
            }
        };
    }
}

