/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.FSOffsetProxy;
import io.github.andreyzebin.gitSql.FileSystem;
import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.bash.BashIO;
import io.github.andreyzebin.gitSql.bash.BashTML;
import io.github.andreyzebin.gitSql.bash.Color;
import io.github.andreyzebin.gitSql.bash.LogWriter;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitCommands;
import io.github.andreyzebin.gitSql.git.GitSource;
import io.github.andreyzebin.gitSql.git.VersionControl;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitFiles
implements FileSystem,
VersionControl {
    private static final Logger log = LoggerFactory.getLogger(GitFiles.class);
    private final BashIO bash;
    private final boolean isReadOnly;
    private final GitAuth authStrategy;
    private final GitSource source;
    private StringBuffer filesToAdd;

    public GitFiles(BashIO bash, boolean isReadOnly, GitAuth authStrategy, GitSource source) {
        this.bash = bash;
        this.isReadOnly = isReadOnly;
        this.authStrategy = authStrategy;
        this.source = source;
        this.filesToAdd = new StringBuffer();
    }

    @Override
    public Writer put(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Bash.append(this.filesToAdd, path.toString());
            return new FileWriter(newFile.toFile(), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getAbs(Path path) {
        return this.source.getRoot().resolve(path);
    }

    @Override
    public boolean erase(Path path) {
        try {
            Path newFile = this.getAbs(path);
            if (Files.exists(newFile, new LinkOption[0])) {
                Files.deleteIfExists(newFile);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Writer patch(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Bash.append(this.filesToAdd, path.toString());
            return new FileWriter(newFile.toFile(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Reader get(Path path) {
        try {
            return new FileReader(this.getAbs(path).toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists(Path path) {
        return this.getAbs(path).toFile().exists();
    }

    @Override
    public boolean isDir(Path path) {
        return this.getAbs(path).toFile().isDirectory();
    }

    @Override
    public String run(String cmd, PrintStream stdOut, PrintStream stdErr, Path path) {
        this.bash.runCommand(cmd, stdOut, stdErr, this.source.getRoot().resolve(path));
        return "";
    }

    @Override
    public String run(String cmd, PrintWriter stdOut, PrintWriter stdErr, Path path) {
        this.bash.runCommand(cmd, stdOut, stdErr, this.source.getRoot().resolve(path));
        return "";
    }

    @Override
    public void find(Function<Path, Boolean> needContinue, Consumer<Path> sayBye, Comparator<Path> sorting) {
        Path root = this.source.getRoot();
        FileSystem.tVerse(root, p -> (Boolean)needContinue.apply(root.relativize((Path)p)), p -> sayBye.accept(root.relativize((Path)p)), sorting);
    }

    @Override
    public void flush() {
        LogWriter outLog;
        LogWriter errLog;
        if (this.isReadOnly) {
            return;
        }
        Path root = this.source.getRoot();
        if (!this.filesToAdd.toString().isBlank()) {
            Arrays.stream(this.filesToAdd.toString().split(System.lineSeparator())).forEach(cFile -> {
                try (LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0), true, f -> new BashTML((String)f).fill(Color.RED).paint("ERROR", Color.RED_BOLD_BRIGHT).toString());
                     LogWriter outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> new BashTML((String)f).fill(Color.GREEN).toString());){
                    GitCommands.add(root, this.bash, Path.of(cFile, new String[0]), outLog.getPW(), errLog.getPW());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        try {
            errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0), true, f -> new BashTML((String)f).fill(Color.RED).paint("ERROR", Color.RED_BOLD_BRIGHT).toString());
            try {
                outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> new BashTML((String)f).fill(Color.GREEN).toString());
                try {
                    GitCommands.commit(root, this.bash, outLog.getPW(), errLog.getPW());
                }
                finally {
                    outLog.close();
                }
            }
            finally {
                errLog.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0), true, f -> new BashTML((String)f).fill(Color.RED).paint("ERROR", Color.RED_BOLD_BRIGHT).toString());
            try {
                outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> new BashTML((String)f).fill(Color.GREEN).toString());
                try {
                    GitCommands.push(root, this.bash, outLog.getPW(), errLog.getPW(), this.authStrategy.useSshAgent());
                }
                finally {
                    outLog.close();
                }
            }
            finally {
                errLog.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.filesToAdd = new StringBuffer();
    }

    @Override
    public FileSystem cd(Path jump) {
        return new FSOffsetProxy(this, jump);
    }

    @Override
    public GitFiles seek(String commit) {
        try (LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0), true, f -> new BashTML((String)f).fill(Color.RED).paint("ERROR", Color.RED_BOLD_BRIGHT).toString());
             LogWriter outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> new BashTML((String)f).fill(Color.GREEN).toString());){
            GitCommands.checkout(this.source.getRoot(), commit, this.bash, outLog.getPW(), errLog.getPW(), this.authStrategy.useSshAgent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Stream<VersionControl.Commit> commits() {
        try (LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0), true, f -> new BashTML((String)f).fill(Color.RED).paint("ERROR", Color.RED_BOLD_BRIGHT).toString());){
            Stream<VersionControl.Commit> stream;
            try (LogWriter outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> new BashTML((String)f).fill(Color.GREEN).toString());){
                stream = GitCommands.commitsList(this.source.getRoot(), this.bash, outLog.getPW(), errLog.getPW());
            }
            return stream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Instant timestamp() {
        try (LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).error(arg_0), true, f -> new BashTML((String)f).fill(Color.RED).paint("ERROR", Color.RED_BOLD_BRIGHT).toString());){
            Instant instant;
            try (LogWriter outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> new BashTML((String)f).fill(Color.GREEN).toString());){
                instant = GitCommands.commitsList(this.source.getRoot(), this.bash, outLog.getPW(), errLog.getPW()).findFirst().get().getTimestampInstant();
            }
            return instant;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.flush();
    }
}

