/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.bash;

import io.github.andreyzebin.gitSql.bash.Color;
import io.github.andreyzebin.gitSql.bash.ColouredBlock;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BashTML {
    private List<ColouredBlock> blocks;

    public BashTML(String s) {
        this.blocks = new LinkedList<ColouredBlock>(List.of(new ColouredBlock(s, null)));
    }

    public BashTML paint(String word, Object c) {
        this.blocks = this.blocks.stream().filter(cW -> !cW.getText().isEmpty()).flatMap(cWord -> {
            List<ColouredBlock> colouredWords = BashTML.joinWithWord(Stream.of((cWord.getText() + " ").split(word)).map(f -> new ColouredBlock((String)f, cWord.getColor())), new ColouredBlock(word, c));
            ColouredBlock last = colouredWords.getLast();
            last.setText(last.getText().substring(0, last.getText().length() - 1));
            colouredWords = colouredWords.stream().filter(cW -> !cW.getText().isEmpty()).toList();
            if (colouredWords.isEmpty()) {
                return Stream.of(new ColouredBlock(word, c));
            }
            return colouredWords.stream();
        }).collect(Collectors.toList());
        return this;
    }

    public BashTML fill(Object c) {
        this.blocks.forEach(cBlock -> cBlock.setColor(c));
        return this;
    }

    public BashTML fillSurrounding(String word, Object c) {
        this.blocks = this.blocks.stream().filter(cW -> !cW.getText().isEmpty()).flatMap(cWord -> {
            Stream<ColouredBlock> wordStream = Stream.of((cWord.getText() + " ").split(word)).map(f -> new ColouredBlock((String)f, cWord.getColor()));
            List<ColouredBlock> colouredWords = BashTML.joinWithWord(wordStream, new ColouredBlock(word, cWord.getColor()));
            ColouredBlock last = colouredWords.getLast();
            last.setText(last.getText().substring(0, last.getText().length() - 1));
            boolean start = false;
            for (ColouredBlock cw : colouredWords) {
                if (start && cw.getText().equals(word)) {
                    start = false;
                    continue;
                }
                if (start) {
                    cw.setColor(c);
                    continue;
                }
                if (!cw.getText().equals(word)) continue;
                start = true;
            }
            return colouredWords.stream();
        }).filter(cW -> !cW.getText().isEmpty()).collect(Collectors.toList());
        return this;
    }

    public static List<ColouredBlock> joinWithWord(Stream<ColouredBlock> bashTMLWordStream, ColouredBlock e) {
        return bashTMLWordStream.reduce(new LinkedList(), (a, b) -> {
            LinkedList<ColouredBlock> bashTMLWords = new LinkedList<ColouredBlock>((Collection<ColouredBlock>)a);
            if (!bashTMLWords.isEmpty()) {
                bashTMLWords.add(e);
            }
            bashTMLWords.add((ColouredBlock)b);
            return bashTMLWords;
        }, (a, b) -> {
            LinkedList<ColouredBlock> objects = new LinkedList<ColouredBlock>((Collection<ColouredBlock>)a);
            if (!a.isEmpty() && !b.isEmpty()) {
                objects.add(e);
            }
            objects.addAll((Collection<ColouredBlock>)b);
            return objects;
        });
    }

    public String toString() {
        return this.blocks.stream().map(cWord -> cWord.getColor() != null ? String.valueOf(cWord.getColor()) + cWord.getText() + String.valueOf((Object)Color.RESET) : cWord.getText()).collect(Collectors.joining());
    }
}

