/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.bash;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.function.Consumer;
import java.util.function.Function;

public class LogWriter
implements AutoCloseable {
    private final Consumer<String> logger;
    private final ByteArrayOutputStream bs = new ByteArrayOutputStream();
    private final boolean splitLines;
    private final Function<String, String> afterRender;

    public LogWriter(Consumer<String> logger) {
        this(logger, false);
    }

    public LogWriter(Consumer<String> logger, boolean splitLines) {
        this(logger, splitLines, f -> f);
    }

    public LogWriter(Consumer<String> logger, boolean splitLines, Function<String, String> afterRender) {
        this.logger = logger;
        this.splitLines = splitLines;
        this.afterRender = afterRender;
    }

    public PrintStream getPS() {
        if (this.splitLines) {
            return new PrintStream(this.bs){

                @Override
                public void println(String x) {
                    super.println(x);
                    LogWriter.this.logger.accept(x);
                }
            };
        }
        return new PrintStream(this.bs);
    }

    public PrintWriter getPW() {
        if (this.splitLines) {
            return new PrintWriter(this.bs){

                @Override
                public void println(String x) {
                    super.println(x);
                    LogWriter.this.logger.accept(LogWriter.this.afterRender.apply(x));
                }
            };
        }
        return new PrintWriter(this.bs);
    }

    @Override
    public void close() throws Exception {
        if (!this.isBlank() && !this.splitLines) {
            this.logger.accept(this.bs.toString());
        }
        this.bs.reset();
    }

    public boolean isBlank() {
        return this.bs.toString().replace(System.lineSeparator(), "").isBlank();
    }

    public String toString() {
        return this.bs.toString();
    }

    public static PrintWriter fork(OutputStream a, final PrintWriter b) {
        return new PrintWriter(a){

            @Override
            public void println(String x) {
                super.println(x);
                b.println(x);
            }
        };
    }
}

