/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.bash.BashCSS;
import io.github.andreyzebin.gitSql.bash.BashIO;
import io.github.andreyzebin.gitSql.bash.BashTML;
import io.github.andreyzebin.gitSql.bash.LogWriter;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitCommands;
import io.github.andreyzebin.gitSql.git.GitSource;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSource
implements GitSource {
    private static final Logger log = LoggerFactory.getLogger(RemoteSource.class);
    private static final String TMP_DIR_NAME = "gitfs_tmp";
    private final String gitUri;
    private final BashIO bash;
    private final Path home;
    private final GitAuth authStrategy;
    private Path root;

    public RemoteSource(String gitUri, BashIO bash, Path home, GitAuth authStrategy) {
        this.gitUri = gitUri;
        this.bash = bash;
        this.home = home;
        this.authStrategy = authStrategy;
    }

    @Override
    public Path getRoot() {
        if (this.root == null) {
            log.debug("Initializing Git root...");
            Path tmp = this.home.resolve(TMP_DIR_NAME).resolve(String.valueOf(System.nanoTime()));
            try (LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> BashCSS.stdErrRender(new BashTML((String)f)).toString());
                 LogWriter outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> BashCSS.stdRender(new BashTML((String)f)).toString());){
                Files.createDirectories(tmp.getParent(), new FileAttribute[0]);
                GitCommands.clone(tmp.getFileName().toString(), this.bash, outLog.getPW(), errLog.getPW(), this.gitUri, false, tmp.getParent(), this.authStrategy.getAuthHeader(), this.authStrategy.useSshAgent());
                if (errLog.toString().contains("ERROR")) {
                    throw new RuntimeException("Could not clone remote source: " + this.gitUri);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!tmp.toFile().exists()) {
                throw new RuntimeException("Could not clone remote source: " + this.gitUri);
            }
            this.root = tmp;
        }
        return this.root;
    }
}

