/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.GitFiles;
import io.github.andreyzebin.gitSql.sql.SqlCSS;
import io.github.andreyzebin.gitSql.sql.SqlUtils;
import io.github.andreyzebin.gitSql.sql.TableSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitsIndexMerger
implements TableSource {
    private static final Logger log = LoggerFactory.getLogger(CommitsIndexMerger.class);
    private final GitFiles git;
    private final String alias;

    public CommitsIndexMerger(GitFiles git, String alias) {
        this.git = git;
        this.alias = alias;
    }

    public static String renderSqlLog(String sql) {
        return System.lineSeparator() + "---" + System.lineSeparator() + sql.lines().map(SqlCSS::sqlRender).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "---";
    }

    @Override
    public SqlUtils.SchemaBuilder createSchema() throws SQLException {
        return new SqlUtils.SchemaBuilder(this.alias).withColumn("hash").withColumn("timestamp", "timestamp timestamp NOT NULL").withColumn("origin").withMerge("origin", "hash");
    }

    @Override
    public Stream<Map<String, String>> rows() {
        return this.git.commits().map(cF -> Map.of("hash", cF.getHash(), "timestamp", cF.getTimestamp(), "origin", this.git.origin().orElse(this.git.getRoot().toString())));
    }
}

