/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.GitFiles;
import io.github.andreyzebin.gitSql.sql.GitUtils;
import io.github.andreyzebin.gitSql.sql.SqlUtils;
import io.github.andreyzebin.gitSql.sql.TableSource;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class RangeIndexMerger
implements TableSource {
    private final Supplier<TableSource> delegate;
    private final Instant from;
    private final Instant to;
    private final GitFiles dataSet;
    private final String alias;

    public RangeIndexMerger(Supplier<TableSource> delegate, Instant from, Instant instant, GitFiles dataSet, String alias) {
        this.alias = alias;
        this.delegate = delegate;
        this.from = from;
        this.to = instant;
        this.dataSet = dataSet;
    }

    @Override
    public SqlUtils.SchemaBuilder createSchema() throws SQLException {
        return this.delegate.get().createSchema().withColumn("ts_point").withColumn("ts_hash").withColumn("ts_origin").withMerge("ts_point");
    }

    @Override
    public Stream<Map<String, String>> rows() {
        return GitUtils.getPoints(this.dataSet, this.from, this.to).flatMap(commit -> {
            this.dataSet.seek(commit.getHash());
            return this.delegate.get().rows().map(cRow -> {
                cRow = new HashMap<String, String>((Map<String, String>)cRow);
                cRow.put("ts_point", commit.getTimestamp());
                cRow.put("ts_hash", commit.getHash());
                cRow.put("ts_origin", this.dataSet.origin().orElse(this.dataSet.getRoot().toString()));
                return cRow;
            });
        });
    }
}

