/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.sql.CommitsIndex;
import io.github.andreyzebin.gitSql.sql.PersistedIndex;
import io.github.andreyzebin.gitSql.sql.SqlUtils;
import io.github.andreyzebin.gitSql.sql.TableSource;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperAggregation
extends PersistedIndex {
    private static final Logger log = LoggerFactory.getLogger(SuperAggregation.class);
    private final Collection<TableSource> sources;

    public SuperAggregation(Path storeDir, Collection<TableSource> sources) {
        super(storeDir);
        this.sources = sources;
    }

    @Override
    protected void createSchema() throws SQLException {
        super.createSchema();
        log.info("Creating schema...");
        try (Statement dml = this.getConnection().createStatement();){
            this.sources.forEach(cSource -> {
                try {
                    String dml1 = cSource.createSchema().toDML();
                    log.debug("Executing DML: " + CommitsIndex.renderSqlLog(dml1));
                    dml.execute(dml1);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void reindex() {
        super.reindex();
        this.sources.forEach(cSource -> cSource.rows().forEach(cRow -> {
            try {
                SqlUtils.merge(this.getConnection(), cSource.createSchema().getAlias(), cSource.createSchema().getMergeColumns(), cRow);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    public SuperAggregation drop() {
        return (SuperAggregation)super.drop();
    }
}

