/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql;

import io.github.andreyzebin.gitSql.FileSystem;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitDb
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(GitDb.class);
    private final FileSystem fileSystem;
    private final Path storeDir;
    private Connection connection;
    private final Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers;
    public static final Map<Function<String, Boolean>, BiFunction<String, Reader, String>> JSON_MAPPERS = Map.of(f -> f.endsWith(".json"), (f, r) -> FileSystem.readLines(r).collect(Collectors.joining(System.lineSeparator())));

    public GitDb(FileSystem fileSystem, Path storeDir, Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers) {
        this.fileSystem = fileSystem;
        this.storeDir = storeDir;
        this.mappers = mappers;
    }

    public Connection getConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            Files.createDirectories(this.storeDir, new FileAttribute[0]);
            String jdbcURL = "jdbc:h2:" + String.valueOf(this.storeDir.resolve("data"));
            this.connection = DriverManager.getConnection(jdbcURL, "", "");
            System.out.println("Connected to H2 embedded database.");
            try (Statement dml = this.connection.createStatement();){
                dml.execute("CREATE TABLE IF NOT EXISTS files (ID INT auto_increment, path VARCHAR(256) NOT NULL, data JSON NOT NULL, UNIQUE NULLS ALL DISTINCT (path) );");
            }
            return this.connection;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void reindex() {
        try {
            Connection dml = this.getConnection();
            this.fileSystem.find(p -> {
                if (!this.fileSystem.isDir((Path)p)) {
                    String fileName = p.getFileName().toString();
                    this.mappers.entrySet().stream().filter(cKey -> (Boolean)((Function)cKey.getKey()).apply(fileName)).findFirst().ifPresent(cF -> GitDb.merge(dml, p.toString(), (String)((BiFunction)cF.getValue()).apply(fileName, this.fileSystem.get((Path)p))));
                }
                return true;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Stream<T> streamRows(Function<ResultSet, T> conv, ResultSet resultSet) {
        try {
            int count = 0;
            LinkedList<T> result = new LinkedList<T>();
            while (resultSet.next()) {
                ++count;
                result.add(conv.apply(resultSet));
            }
            return result.stream();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<Map.Entry<String, String>> streamFields(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            LinkedList<AbstractMap.SimpleEntry<String, String>> all = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
            for (int i = 1; i <= columnCount; ++i) {
                String name = rsmd.getColumnName(i);
                all.add(new AbstractMap.SimpleEntry<String, String>(name, rs.getString(name)));
            }
            return all.stream();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static int merge(Connection con, String path, String json) {
        int n;
        block8: {
            String sql = "   merge into files\n   using values (?,? FORMAT JSON) as incoming(path, data)\n   on files.path = incoming.path\n   when not matched then\n       insert (path, data) values (incoming.path, incoming.data)\n   when matched then\n       update set data = incoming.data;\n";
            PreparedStatement statement = con.prepareStatement("   merge into files\n   using values (?,? FORMAT JSON) as incoming(path, data)\n   on files.path = incoming.path\n   when not matched then\n       insert (path, data) values (incoming.path, incoming.data)\n   when matched then\n       update set data = incoming.data;\n");
            try {
                log.debug("   merge into files\n   using values (?,? FORMAT JSON) as incoming(path, data)\n   on files.path = incoming.path\n   when not matched then\n       insert (path, data) values (incoming.path, incoming.data)\n   when matched then\n       update set data = incoming.data;\n");
                statement.setString(1, path);
                statement.setString(2, json);
                n = statement.executeUpdate();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return n;
    }

    public static ResultSet query(Connection con, String sql, String ... values) {
        PreparedStatement statement = null;
        try {
            statement = con.prepareStatement(sql);
            log.debug(sql);
            for (int i = 0; i < values.length; ++i) {
                statement.setString(i + 1, values[i]);
            }
            return statement.executeQuery();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static int queryUpdate(Connection con, String sql, String ... values) {
        int n;
        block9: {
            PreparedStatement statement = con.prepareStatement(sql);
            try {
                log.debug(sql);
                for (int i = 0; i < values.length; ++i) {
                    statement.setString(i + 1, values[i]);
                }
                n = statement.executeUpdate();
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            statement.close();
        }
        return n;
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }
}

