/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.FileSystem;
import io.github.andreyzebin.gitSql.bash.BashCSS;
import io.github.andreyzebin.gitSql.bash.BashIO;
import io.github.andreyzebin.gitSql.bash.BashTML;
import io.github.andreyzebin.gitSql.bash.LogWriter;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitCommands;
import io.github.andreyzebin.gitSql.git.GitSource;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSource
implements GitSource {
    private static final Logger log = LoggerFactory.getLogger(RemoteSource.class);
    private static final String TMP_DIR_NAME = "gitfs_tmp";
    private final String gitUri;
    private final BashIO bash;
    private final Path home;
    private final GitAuth authStrategy;
    private Path root;
    private final String branch;

    public RemoteSource(String gitUri, BashIO bash, Path home, GitAuth authStrategy) {
        this(gitUri, bash, home, authStrategy, null);
    }

    public RemoteSource(String gitUri, BashIO bash, Path home, GitAuth authStrategy, String branch) {
        this.branch = branch;
        this.gitUri = gitUri;
        this.bash = bash;
        this.home = home;
        this.authStrategy = authStrategy;
    }

    @Override
    public void close() throws Exception {
        if (this.root != null) {
            log.debug("Cleaning up temporary git root...");
            FileSystem.deleteRecursively(this.root);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Stream<BranchHead> listBranches() {
        try (LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> BashCSS.stdErrRender(new BashTML((String)f)).toString());){
            Stream<BranchHead> stream;
            try (LogWriter outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> BashCSS.stdRender(new BashTML((String)f)).toString());){
                stream = GitCommands.getRemoteBranches(this.gitUri, this.bash, outLog.getPW(), errLog.getPW(), this.authStrategy.getAuthHeader(), this.authStrategy.useSshAgent());
            }
            return stream;
        }
        catch (Exception e) {
            log.error("Could not list remote branches, because: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getRoot() {
        if (this.root == null) {
            log.debug("Initializing Git root...");
            Path tmp = this.home.resolve(TMP_DIR_NAME).resolve(String.valueOf(System.nanoTime()));
            try (LogWriter errLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> BashCSS.stdErrRender(new BashTML((String)f)).toString());
                 LogWriter outLog = new LogWriter(arg_0 -> ((Logger)log).debug(arg_0), true, f -> BashCSS.stdRender(new BashTML((String)f)).toString());){
                Files.createDirectories(tmp.getParent(), new FileAttribute[0]);
                if (this.branch != null) {
                    GitCommands.clone(tmp.getFileName().toString(), this.bash, outLog.getPW(), errLog.getPW(), this.gitUri, false, tmp.getParent(), this.authStrategy.getAuthHeader(), this.authStrategy.useSshAgent(), this.branch);
                } else {
                    GitCommands.clone(tmp.getFileName().toString(), this.bash, outLog.getPW(), errLog.getPW(), this.gitUri, false, tmp.getParent(), this.authStrategy.getAuthHeader(), this.authStrategy.useSshAgent());
                }
                if (errLog.toString().contains("ERROR")) {
                    throw new RuntimeException("Could not clone remote source: " + this.gitUri);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!tmp.toFile().exists()) {
                throw new RuntimeException("Could not clone remote source: " + this.gitUri);
            }
            this.root = tmp;
        }
        return this.root;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteSource that = (RemoteSource)o;
        return Objects.equals(this.gitUri, that.gitUri) && Objects.equals(this.branch, that.branch);
    }

    public int hashCode() {
        return Objects.hash(this.gitUri, this.branch);
    }

    public static class BranchHead {
        String name;
        String hash;

        BranchHead(String name, String hash) {
            this.name = name;
            this.hash = hash;
        }

        public static BranchHeadBuilder builder() {
            return new BranchHeadBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getHash() {
            return this.hash;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BranchHead)) {
                return false;
            }
            BranchHead other = (BranchHead)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BranchHead;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            return result;
        }

        public String toString() {
            return "RemoteSource.BranchHead(name=" + this.getName() + ", hash=" + this.getHash() + ")";
        }

        public static class BranchHeadBuilder {
            private String name;
            private String hash;

            BranchHeadBuilder() {
            }

            public BranchHeadBuilder name(String name) {
                this.name = name;
                return this;
            }

            public BranchHeadBuilder hash(String hash) {
                this.hash = hash;
                return this;
            }

            public BranchHead build() {
                return new BranchHead(this.name, this.hash);
            }

            public String toString() {
                return "RemoteSource.BranchHead.BranchHeadBuilder(name=" + this.name + ", hash=" + this.hash + ")";
            }
        }
    }
}

