/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.FileSystem;
import io.github.andreyzebin.gitSql.git.GitFiles;
import io.github.andreyzebin.gitSql.git.VersionControl;
import io.github.andreyzebin.gitSql.sql.SqlUtils;
import io.github.andreyzebin.gitSql.sql.TableSource;
import java.io.Reader;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesIndexMerger
implements TableSource {
    private static final Logger log = LoggerFactory.getLogger(FilesIndexMerger.class);
    private final GitFiles fileSystem;
    private final String alias;
    private final Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers;
    private String updates = null;
    public static final Map<Function<String, Boolean>, BiFunction<String, Reader, String>> JSON_MAPPERS = Map.of(f -> f.endsWith(".json"), (f, r) -> FileSystem.readLines(r).collect(Collectors.joining(System.lineSeparator())));

    public FilesIndexMerger(GitFiles fileSystem, String alias, Map<Function<String, Boolean>, BiFunction<String, Reader, String>> mappers) {
        this.fileSystem = fileSystem;
        this.alias = alias;
        this.mappers = mappers;
    }

    @Override
    public TableSource updates(String fromVersion) {
        this.updates = fromVersion;
        return this;
    }

    @Override
    public String version() {
        return this.getHash();
    }

    private String getHash() {
        return this.fileSystem.commits().findFirst().get().getHash();
    }

    @Override
    public SqlUtils.SchemaBuilder createSchema() throws SQLException {
        return new SqlUtils.SchemaBuilder(this.alias).withColumn("path").withColumn("data", "data JSON NOT NULL").withColumn("origin").withMerge("origin", "path").withIndex("UNIQUE NULLS ALL DISTINCT (origin, path)");
    }

    @Override
    public Stream<Map<String, String>> rows() {
        LinkedList rows = new LinkedList();
        if (this.updates == null) {
            this.fileSystem.find(p -> {
                if (!this.fileSystem.isDir((Path)p)) {
                    this.addRow((Path)p, rows);
                }
                return true;
            });
        } else {
            this.fileSystem.changes(this.updates).filter(VersionControl.Change::isUpdate).forEach(change -> this.addRow(Path.of(change.getFile(), new String[0]), rows));
        }
        return rows.stream();
    }

    private void addRow(Path p, List<Map<String, String>> rows) {
        String fileName = p.getFileName().toString();
        this.mappers.entrySet().stream().filter(cKey -> (Boolean)((Function)cKey.getKey()).apply(fileName)).findFirst().ifPresent(cF -> rows.add(Map.of("path", p.toString(), "data FORMAT JSON", (String)((BiFunction)cF.getValue()).apply(fileName, this.fileSystem.get(p)), "origin", this.fileSystem.origin().orElse(this.fileSystem.getRoot().toString()))));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilesIndexMerger that = (FilesIndexMerger)o;
        return Objects.equals(this.fileSystem.getSource(), that.fileSystem.getSource()) && Objects.equals(this.alias, that.alias) && Objects.equals(this.mappers, that.mappers);
    }

    public int hashCode() {
        return Objects.hash(this.fileSystem.getSource(), this.alias, this.mappers, this.getClass().getName());
    }
}

