/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql;

import io.github.andreyzebin.gitSql.Bash;
import io.github.andreyzebin.gitSql.BashIO;
import java.io.PrintStream;
import java.nio.file.Path;

public class GitCommands {
    public static void clone(String target, BashIO bash, PrintStream out, PrintStream err, String uri, boolean isQuiet, Path cd, String authHeader) {
        String props = isQuiet ? " --quiet" : " ";
        bash.runCommand("ssh-add && git clone -c core.protectNTFS=false " + authHeader + " " + uri + props + " " + target, out, err, cd);
    }

    public static void add(Path repo, BashIO bash, Path relative, PrintStream out, PrintStream err) {
        bash.runCommand("git add " + Bash.escape(Bash.toPosix(relative)), out, err, repo);
    }

    public static void commit(Path repo, BashIO bash, PrintStream out, PrintStream err) {
        bash.runCommand("git commit -a -m \"msg\"", out, err, repo);
    }

    public static void push(Path repo, BashIO bash, PrintStream out, PrintStream err, String authHeader) {
        bash.runCommand("ssh-add && git push " + authHeader, out, err, repo);
    }
}

