/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.bash;

import io.github.andreyzebin.gitSql.bash.BashIO;
import io.github.andreyzebin.gitSql.bash.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.function.Function;

public class Bash
implements BashIO {
    public static final String WIN_BASH_PATH = "C:\\Program Files\\Git\\bin\\bash.exe";
    private final boolean isSilent;
    private final Runtime runtime;
    private final Function<Runtime, Process> terminals;

    public Bash(boolean isSilent, Runtime runtime, Function<Runtime, Process> terminals) {
        this.isSilent = isSilent;
        this.runtime = runtime;
        this.terminals = terminals;
    }

    @Override
    public void runCommand(String str, PrintStream out, PrintStream err, Path cd) {
        Process t = this.terminals.apply(this.runtime);
        StringBuffer cmd = new StringBuffer();
        try (BufferedWriter bw = t.outputWriter();){
            cmd.append(this.cdCommand(cd));
            cmd.append(" && ");
            cmd.append(str);
            bw.write(cmd.toString());
            if (!this.isSilent) {
                System.out.println(String.valueOf((Object)Color.YELLOW) + "bash: " + String.valueOf(cmd) + String.valueOf((Object)Color.RESET));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        t.inputReader().lines().forEach(out::println);
        t.inputReader().lines().forEach(err::println);
    }

    private String cdCommand(Path jump) {
        return "cd " + Bash.escape(Bash.toAbsolutePosix(jump));
    }

    public static String escape(String posix) {
        return "\"" + posix + "\"";
    }

    public static String decode(String value) {
        return Bash.removeSurrounding(Bash.removeSurrounding(value, "'"), "\"");
    }

    private static String removeSurrounding(String value, String prefix) {
        if (value.startsWith(prefix) && value.endsWith(prefix)) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static String toAbsolutePosix(Path p) {
        return Bash.toPosix("/" + String.valueOf(p.toAbsolutePath().normalize()));
    }

    private static String toPosix(String p) {
        return p.replace("\\", "/").replace(":", "");
    }

    public static String toPosix(Path p) {
        return Bash.toPosix(p.toString());
    }

    public static void append(StringBuffer buf, String line) {
        if (!buf.isEmpty()) {
            buf.append(System.lineSeparator());
        }
        buf.append(line);
    }

    public static Process runWinShell(Runtime runtime) {
        return Bash.runShell(runtime, WIN_BASH_PATH);
    }

    public static Process runShell(Runtime runtime, String winBashPath) {
        Process terminal = null;
        try {
            terminal = runtime.exec(new String[]{winBashPath});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return terminal;
    }

    public static Process runShellForOs(Runtime r) {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        if (isWindows) {
            return Bash.runWinShell(r);
        }
        return Bash.runShell(r, "/bin/sh");
    }
}

