/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.bash.Color;
import io.github.andreyzebin.gitSql.sql.TableComposition;
import io.github.andreyzebin.gitSql.sql.TablePrinter;
import io.github.andreyzebin.gitSql.sql.TableStreamRow;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MyTableComposition
implements TableComposition {
    private final String horizontalSplitter;
    private final String brick;
    private final ToIntFunction<Map.Entry<String, String>> columnOrder;
    private final ToIntFunction<Stream<Map.Entry<String, String>>> indents;
    private final boolean headingHorizontalBorders;
    private final boolean totalsHorizontalBorders;
    private final boolean needAfterRows;
    private final String surround;
    private final boolean hasTabulation;
    private final Function<Map.Entry<String, String>, String> totalsRender;

    public MyTableComposition(String horizontalSplitter, String verticalSplitter, ToIntFunction<Map.Entry<String, String>> columnOrder, ToIntFunction<Stream<Map.Entry<String, String>>> indents, boolean headingHorizontalBorders, boolean totalsHorizontalBorders, boolean needAfterRows, String surround, boolean hasTabulation, Function<Map.Entry<String, String>, String> totalsRender) {
        this.horizontalSplitter = horizontalSplitter;
        this.brick = verticalSplitter;
        this.columnOrder = columnOrder;
        this.indents = indents;
        this.headingHorizontalBorders = headingHorizontalBorders;
        this.totalsHorizontalBorders = totalsHorizontalBorders;
        this.needAfterRows = needAfterRows;
        this.surround = surround;
        this.hasTabulation = hasTabulation;
        this.totalsRender = totalsRender;
    }

    public static String fill(int length, String brick) {
        return Stream.generate(() -> brick).limit(length).collect(Collectors.joining());
    }

    private Collector<Map.Entry<String, String>, List<String>, String> indent(final Map<String, Integer> colNames, final String delimiter) {
        return new Collector<Map.Entry<String, String>, List<String>, String>(){

            @Override
            public Supplier<List<String>> supplier() {
                return LinkedList::new;
            }

            @Override
            public BiConsumer<List<String>, Map.Entry<String, String>> accumulator() {
                return (a, b) -> {
                    if (colNames.containsKey(((String)b.getKey()).toLowerCase())) {
                        Object value = (String)b.getValue();
                        if (MyTableComposition.this.hasTabulation) {
                            Integer maxWidth = (Integer)colNames.get(((String)b.getKey()).toLowerCase());
                            value = (String)b.getValue();
                            value = ((String)value).length() > maxWidth - 1 ? ((String)value).substring(0, maxWidth - 4) + "... " : (String)value + MyTableComposition.fill(maxWidth - ((String)value).length(), " ");
                        } else {
                            value = MyTableComposition.this.surround + (String)value + MyTableComposition.this.surround;
                        }
                        a.add(value);
                    }
                };
            }

            @Override
            public BinaryOperator<List<String>> combiner() {
                return (a, b) -> {
                    a.addAll(b);
                    return a;
                };
            }

            @Override
            public Function<List<String>, String> finisher() {
                return a -> {
                    StringJoiner stringJoiner = new StringJoiner(delimiter);
                    a.forEach(stringJoiner::add);
                    return stringJoiner.toString();
                };
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Set.of();
            }
        };
    }

    private Function<Map<String, String>, String> formattedTable() {
        return r -> {
            Stream rowRAW = r.entrySet().stream();
            Map<String, Integer> indents = r.entrySet().stream().collect(Collectors.toMap(stringStringEntry -> ((String)stringStringEntry.getKey()).toLowerCase(), cCol -> this.indents.applyAsInt(Stream.of(cCol))));
            return rowRAW.sorted(Comparator.comparingInt(this.columnOrder)).collect(this.indent(indents, this.horizontalSplitter));
        };
    }

    @Override
    public void getAfterRows(TablePrinter tableStream, LinkedList<String> strings) {
        if (this.needAfterRows) {
            this.printTotals(tableStream, this.totalsRender, strings);
        }
    }

    @Override
    public Consumer<TableStreamRow> getRowConsumer(LinkedList<String> strings) {
        return row -> {
            Map<String, String> rowWithTotals = row.getRowWithTotals();
            if (!row.getTable().isHeaderPrinted()) {
                Integer sumWidth = rowWithTotals.entrySet().stream().map(r -> this.indents.applyAsInt(Stream.of(r))).reduce(Integer::sum).get();
                if (this.headingHorizontalBorders) {
                    strings.add(MyTableComposition.fill(sumWidth, this.brick));
                }
                MyTableComposition.printHeading(row, strings, this.formattedTable());
                if (this.headingHorizontalBorders) {
                    strings.add(MyTableComposition.fill(sumWidth, this.brick));
                }
            }
            strings.add(this.formattedTable().apply(rowWithTotals));
        };
    }

    public void printTotals(TablePrinter tableStream, Function<Map.Entry<String, String>, String> totalsRender, LinkedList<String> strings) {
        Integer sumWidth = tableStream.getLast().getRowWithTotals().entrySet().stream().map(r -> this.indents.applyAsInt(Stream.of(r))).reduce(Integer::sum).get();
        if (this.totalsHorizontalBorders) {
            strings.add(MyTableComposition.fill(sumWidth, this.brick));
        }
        strings.add("Total: " + String.valueOf((Object)Color.WHITE_BOLD_BRIGHT) + tableStream.getLast().getTotals().entrySet().stream().map(ce -> new AbstractMap.SimpleEntry<String, String>((String)ce.getKey(), ((Integer)ce.getValue()).toString())).map(totalsRender).collect(Collectors.joining(this.brick)) + String.valueOf((Object)Color.RESET));
    }

    private static void printHeading(TableStreamRow row, LinkedList<String> strings, Function<Map<String, String>, String> tableRender) {
        Map<String, String> heading = TablePrinter.combine(row.getTable().getHeaders(), row.getTotals().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getKey)));
        strings.add(tableRender.apply(heading));
        row.getTable().setHeaderPrinted(true);
    }
}

