/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.FSOffsetProxy;
import io.github.andreyzebin.gitSql.FileSystem;
import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.bash.BashIO;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitCommands;
import io.github.andreyzebin.gitSql.git.VersionControl;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class GitFS
implements FileSystem,
VersionControl {
    private static final String TMP_DIR_NAME = "tmp";
    private final String gitUri;
    private final BashIO bash;
    private final Path home;
    private Path root;
    StringBuffer filesToAdd;
    private final boolean isReadOnly;
    private final GitAuth authStrategy;

    public GitFS(String gitUri, BashIO bash, Path home, boolean isReadOnly, GitAuth authStrategy) {
        this.gitUri = gitUri;
        this.bash = bash;
        this.home = home;
        this.isReadOnly = isReadOnly;
        this.authStrategy = authStrategy;
    }

    private Path getRoot() {
        if (this.root == null) {
            Path tmp = this.home.resolve(TMP_DIR_NAME).resolve(String.valueOf(System.nanoTime()));
            try {
                Files.createDirectories(tmp.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            GitCommands.clone(tmp.getFileName().toString(), this.bash, System.out, System.out, this.gitUri, false, tmp.getParent(), this.authStrategy.getAuthHeader());
            if (!tmp.toFile().exists()) {
                throw new RuntimeException("Could not pull repository: " + this.gitUri);
            }
            this.root = tmp;
            this.filesToAdd = new StringBuffer();
        }
        return this.root;
    }

    @Override
    public Writer put(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Bash.append(this.filesToAdd, path.toString());
            return new FileWriter(newFile.toFile(), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getAbs(Path path) {
        return this.getRoot().resolve(path);
    }

    @Override
    public boolean erase(Path path) {
        try {
            Path newFile = this.getAbs(path);
            if (Files.exists(newFile, new LinkOption[0])) {
                Files.deleteIfExists(newFile);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Writer patch(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Bash.append(this.filesToAdd, path.toString());
            return new FileWriter(newFile.toFile(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Reader get(Path path) {
        try {
            return new FileReader(this.getAbs(path).toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists(Path path) {
        return this.getAbs(path).toFile().exists();
    }

    @Override
    public boolean isDir(Path path) {
        return this.getAbs(path).toFile().isDirectory();
    }

    @Override
    public String run(String cmd, PrintStream stdOut, PrintStream stdErr, Path path) {
        this.bash.runCommand(cmd, stdOut, stdErr, this.getRoot().resolve(path));
        return "";
    }

    @Override
    public void find(Function<Path, Boolean> needContinue, Consumer<Path> sayBye, Comparator<Path> sorting) {
        Path root = this.getRoot();
        FileSystem.tVerse(root, p -> (Boolean)needContinue.apply(root.relativize((Path)p)), p -> sayBye.accept(root.relativize((Path)p)), sorting);
    }

    @Override
    public void flush() {
        if (this.isReadOnly) {
            return;
        }
        Path root = this.getRoot();
        if (!this.filesToAdd.toString().isBlank()) {
            Arrays.stream(this.filesToAdd.toString().split(System.lineSeparator())).forEach(cFile -> GitCommands.add(root, this.bash, Path.of(cFile, new String[0]), System.out, System.out));
        }
        GitCommands.commit(root, this.bash, System.out, System.out);
        GitCommands.push(root, this.bash, System.out, System.out, this.authStrategy.getAuthHeader());
        this.filesToAdd = new StringBuffer();
    }

    @Override
    public FileSystem cd(Path jump) {
        return new FSOffsetProxy(this, jump);
    }

    @Override
    public GitFS seek(String commit) {
        GitCommands.checkout(this.getRoot(), commit, this.bash, System.out, System.err, this.authStrategy.getAuthHeader());
        return this;
    }

    public Stream<VersionControl.Commit> commits() {
        return GitCommands.commitsList(this.getRoot(), this.bash, System.err);
    }

    @Override
    public Instant timestamp() {
        return GitCommands.commitsList(this.getRoot(), this.bash, System.out).findFirst().get().getTimestampInstant();
    }

    @Override
    public void close() throws Exception {
        this.flush();
    }
}

