/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.bash.Color;
import io.github.andreyzebin.gitSql.sql.ResultRenders;
import io.github.andreyzebin.gitSql.sql.TableComposition;
import io.github.andreyzebin.gitSql.sql.TablePrinter;
import io.github.andreyzebin.gitSql.sql.TableStreamRow;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MyTableComposition
implements TableComposition {
    private String horizontalSplitter;
    private String brick;
    private ToIntFunction<Map.Entry<String, String>> columnOrder;
    private ToIntFunction<Stream<Map.Entry<String, String>>> indents;
    private boolean headingHorizontalBorders;
    private boolean totalsHorizontalBorders;
    private boolean needAfterRows;
    private String surround;
    private boolean hasTabulation;
    private Function<Map.Entry<String, String>, String> totalsRender;

    public MyTableComposition(String horizontalSplitter, String verticalSplitter, ToIntFunction<Map.Entry<String, String>> columnOrder, ToIntFunction<Stream<Map.Entry<String, String>>> indents, boolean headingHorizontalBorders, boolean totalsHorizontalBorders, boolean needAfterRows, String surround, boolean hasTabulation, Function<Map.Entry<String, String>, String> totalsRender) {
        this.horizontalSplitter = horizontalSplitter;
        this.brick = verticalSplitter;
        this.columnOrder = columnOrder;
        this.indents = indents;
        this.headingHorizontalBorders = headingHorizontalBorders;
        this.totalsHorizontalBorders = totalsHorizontalBorders;
        this.needAfterRows = needAfterRows;
        this.surround = surround;
        this.hasTabulation = hasTabulation;
        this.totalsRender = totalsRender;
    }

    public static String fill(int length, String brick) {
        return Stream.generate(() -> brick).limit(length).collect(Collectors.joining());
    }

    public static MyTableComposition dumpCSV(List<String> rowNumber, String horizontalSplitter, String surround) {
        return new MyTableComposition(horizontalSplitter, "", MyTableComposition.constantOrder(rowNumber), value -> ((String)((Map.Entry)value.findFirst().get()).getValue()).length() + 1, false, false, false, surround, false, ResultRenders.renderValue());
    }

    public static MyTableComposition prettyPrint(int defaultWidth, List<AbstractMap.SimpleEntry<String, Integer>> columns) {
        return new MyTableComposition("", "-", MyTableComposition.constantOrder(columns.stream().map(AbstractMap.SimpleEntry::getKey).collect(Collectors.toList())), MyTableComposition.constantWidth(columns.stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)), defaultWidth), true, true, true, "", true, ResultRenders.renderValue());
    }

    public static Consumer<String> println(BufferedWriter br) {
        return cLine -> {
            try {
                br.write((String)cLine);
                br.newLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static ToIntFunction<Stream<Map.Entry<String, String>>> constantWidth(Map<String, Integer> rowNumber, int defaultValue) {
        return a -> {
            String key = a.map(Map.Entry::getKey).reduce((aa, bb) -> aa).get().toLowerCase();
            return rowNumber.getOrDefault(key, defaultValue);
        };
    }

    public static ToIntFunction<Map.Entry<String, String>> constantOrder(List<String> cols) {
        return aa -> {
            HashMap colIndexes = new HashMap();
            cols.forEach(key -> colIndexes.put(key.toLowerCase(), colIndexes.size()));
            return Optional.ofNullable((Integer)colIndexes.get(((String)aa.getKey()).toLowerCase())).orElse(Integer.MAX_VALUE);
        };
    }

    private Collector<Map.Entry<String, String>, List<String>, String> indent(final Map<String, Integer> colNames, final String delimiter) {
        return new Collector<Map.Entry<String, String>, List<String>, String>(){

            @Override
            public Supplier<List<String>> supplier() {
                return LinkedList::new;
            }

            @Override
            public BiConsumer<List<String>, Map.Entry<String, String>> accumulator() {
                return (a, b) -> {
                    if (colNames.containsKey(((String)b.getKey()).toLowerCase())) {
                        Object value = (String)b.getValue();
                        if (MyTableComposition.this.hasTabulation) {
                            Integer maxWidth = (Integer)colNames.get(((String)b.getKey()).toLowerCase());
                            value = (String)b.getValue();
                            value = ((String)value).length() > maxWidth - 1 ? ((String)value).substring(0, maxWidth - 4) + "... " : (String)value + MyTableComposition.fill(maxWidth - ((String)value).length(), " ");
                        } else {
                            value = MyTableComposition.this.surround + (String)value + MyTableComposition.this.surround;
                        }
                        a.add(value);
                    }
                };
            }

            @Override
            public BinaryOperator<List<String>> combiner() {
                return (a, b) -> {
                    a.addAll(b);
                    return a;
                };
            }

            @Override
            public Function<List<String>, String> finisher() {
                return a -> {
                    StringJoiner stringJoiner = new StringJoiner(delimiter);
                    a.forEach(stringJoiner::add);
                    return stringJoiner.toString();
                };
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Set.of();
            }
        };
    }

    private Function<Map<String, String>, String> formattedTable() {
        return r -> {
            Stream rowRAW = r.entrySet().stream();
            Map<String, Integer> indents = r.entrySet().stream().collect(Collectors.toMap(stringStringEntry -> ((String)stringStringEntry.getKey()).toLowerCase(), cCol -> this.indents.applyAsInt(Stream.of(cCol))));
            return rowRAW.sorted(Comparator.comparingInt(this.columnOrder)).collect(this.indent(indents, this.horizontalSplitter));
        };
    }

    @Override
    public void getAfterRows(TablePrinter tableStream, LinkedList<String> strings) {
        if (this.needAfterRows) {
            this.printTotals(tableStream, this.totalsRender, strings);
        }
    }

    @Override
    public Consumer<TableStreamRow> getRowConsumer(LinkedList<String> strings) {
        return row -> {
            Map<String, String> rowWithTotals = row.getRowWithTotals();
            if (!row.getTable().isHeaderPrinted()) {
                Integer sumWidth = rowWithTotals.entrySet().stream().map(r -> this.indents.applyAsInt(Stream.of(r))).reduce(Integer::sum).get();
                if (this.headingHorizontalBorders) {
                    strings.add(MyTableComposition.fill(sumWidth, this.brick));
                }
                MyTableComposition.printHeading(row, strings, this.formattedTable());
                if (this.headingHorizontalBorders) {
                    strings.add(MyTableComposition.fill(sumWidth, this.brick));
                }
            }
            strings.add(this.formattedTable().apply(rowWithTotals));
        };
    }

    public void printTotals(TablePrinter tableStream, Function<Map.Entry<String, String>, String> totalsRender, LinkedList<String> strings) {
        Integer sumWidth = tableStream.getLast().getRowWithTotals().entrySet().stream().map(r -> this.indents.applyAsInt(Stream.of(r))).reduce(Integer::sum).get();
        if (this.totalsHorizontalBorders) {
            strings.add(MyTableComposition.fill(sumWidth, this.brick));
        }
        strings.add("Total: " + String.valueOf((Object)Color.WHITE_BOLD_BRIGHT) + tableStream.getLast().getTotals().entrySet().stream().map(ce -> new AbstractMap.SimpleEntry<String, String>((String)ce.getKey(), ((Integer)ce.getValue()).toString())).map(totalsRender).collect(Collectors.joining(this.brick)) + String.valueOf((Object)Color.RESET));
    }

    private static void printHeading(TableStreamRow row, LinkedList<String> strings, Function<Map<String, String>, String> tableRender) {
        Map<String, String> heading = TablePrinter.combine(row.getTable().getHeaders(), row.getTotals().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getKey)));
        strings.add(tableRender.apply(heading));
        row.getTable().setHeaderPrinted(true);
    }

    public static MyTableCompositionBuilder builder() {
        return new MyTableCompositionBuilder();
    }

    public String getHorizontalSplitter() {
        return this.horizontalSplitter;
    }

    public String getBrick() {
        return this.brick;
    }

    public ToIntFunction<Map.Entry<String, String>> getColumnOrder() {
        return this.columnOrder;
    }

    public ToIntFunction<Stream<Map.Entry<String, String>>> getIndents() {
        return this.indents;
    }

    public boolean isHeadingHorizontalBorders() {
        return this.headingHorizontalBorders;
    }

    public boolean isTotalsHorizontalBorders() {
        return this.totalsHorizontalBorders;
    }

    public boolean isNeedAfterRows() {
        return this.needAfterRows;
    }

    public String getSurround() {
        return this.surround;
    }

    public boolean isHasTabulation() {
        return this.hasTabulation;
    }

    public Function<Map.Entry<String, String>, String> getTotalsRender() {
        return this.totalsRender;
    }

    public void setHorizontalSplitter(String horizontalSplitter) {
        this.horizontalSplitter = horizontalSplitter;
    }

    public void setBrick(String brick) {
        this.brick = brick;
    }

    public void setColumnOrder(ToIntFunction<Map.Entry<String, String>> columnOrder) {
        this.columnOrder = columnOrder;
    }

    public void setIndents(ToIntFunction<Stream<Map.Entry<String, String>>> indents) {
        this.indents = indents;
    }

    public void setHeadingHorizontalBorders(boolean headingHorizontalBorders) {
        this.headingHorizontalBorders = headingHorizontalBorders;
    }

    public void setTotalsHorizontalBorders(boolean totalsHorizontalBorders) {
        this.totalsHorizontalBorders = totalsHorizontalBorders;
    }

    public void setNeedAfterRows(boolean needAfterRows) {
        this.needAfterRows = needAfterRows;
    }

    public void setSurround(String surround) {
        this.surround = surround;
    }

    public void setHasTabulation(boolean hasTabulation) {
        this.hasTabulation = hasTabulation;
    }

    public void setTotalsRender(Function<Map.Entry<String, String>, String> totalsRender) {
        this.totalsRender = totalsRender;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MyTableComposition)) {
            return false;
        }
        MyTableComposition other = (MyTableComposition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHeadingHorizontalBorders() != other.isHeadingHorizontalBorders()) {
            return false;
        }
        if (this.isTotalsHorizontalBorders() != other.isTotalsHorizontalBorders()) {
            return false;
        }
        if (this.isNeedAfterRows() != other.isNeedAfterRows()) {
            return false;
        }
        if (this.isHasTabulation() != other.isHasTabulation()) {
            return false;
        }
        String this$horizontalSplitter = this.getHorizontalSplitter();
        String other$horizontalSplitter = other.getHorizontalSplitter();
        if (this$horizontalSplitter == null ? other$horizontalSplitter != null : !this$horizontalSplitter.equals(other$horizontalSplitter)) {
            return false;
        }
        String this$brick = this.getBrick();
        String other$brick = other.getBrick();
        if (this$brick == null ? other$brick != null : !this$brick.equals(other$brick)) {
            return false;
        }
        ToIntFunction<Map.Entry<String, String>> this$columnOrder = this.getColumnOrder();
        ToIntFunction<Map.Entry<String, String>> other$columnOrder = other.getColumnOrder();
        if (this$columnOrder == null ? other$columnOrder != null : !this$columnOrder.equals(other$columnOrder)) {
            return false;
        }
        ToIntFunction<Stream<Map.Entry<String, String>>> this$indents = this.getIndents();
        ToIntFunction<Stream<Map.Entry<String, String>>> other$indents = other.getIndents();
        if (this$indents == null ? other$indents != null : !this$indents.equals(other$indents)) {
            return false;
        }
        String this$surround = this.getSurround();
        String other$surround = other.getSurround();
        if (this$surround == null ? other$surround != null : !this$surround.equals(other$surround)) {
            return false;
        }
        Function<Map.Entry<String, String>, String> this$totalsRender = this.getTotalsRender();
        Function<Map.Entry<String, String>, String> other$totalsRender = other.getTotalsRender();
        return !(this$totalsRender == null ? other$totalsRender != null : !this$totalsRender.equals(other$totalsRender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MyTableComposition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHeadingHorizontalBorders() ? 79 : 97);
        result = result * 59 + (this.isTotalsHorizontalBorders() ? 79 : 97);
        result = result * 59 + (this.isNeedAfterRows() ? 79 : 97);
        result = result * 59 + (this.isHasTabulation() ? 79 : 97);
        String $horizontalSplitter = this.getHorizontalSplitter();
        result = result * 59 + ($horizontalSplitter == null ? 43 : $horizontalSplitter.hashCode());
        String $brick = this.getBrick();
        result = result * 59 + ($brick == null ? 43 : $brick.hashCode());
        ToIntFunction<Map.Entry<String, String>> $columnOrder = this.getColumnOrder();
        result = result * 59 + ($columnOrder == null ? 43 : $columnOrder.hashCode());
        ToIntFunction<Stream<Map.Entry<String, String>>> $indents = this.getIndents();
        result = result * 59 + ($indents == null ? 43 : $indents.hashCode());
        String $surround = this.getSurround();
        result = result * 59 + ($surround == null ? 43 : $surround.hashCode());
        Function<Map.Entry<String, String>, String> $totalsRender = this.getTotalsRender();
        result = result * 59 + ($totalsRender == null ? 43 : $totalsRender.hashCode());
        return result;
    }

    public String toString() {
        return "MyTableComposition(horizontalSplitter=" + this.getHorizontalSplitter() + ", brick=" + this.getBrick() + ", columnOrder=" + String.valueOf(this.getColumnOrder()) + ", indents=" + String.valueOf(this.getIndents()) + ", headingHorizontalBorders=" + this.isHeadingHorizontalBorders() + ", totalsHorizontalBorders=" + this.isTotalsHorizontalBorders() + ", needAfterRows=" + this.isNeedAfterRows() + ", surround=" + this.getSurround() + ", hasTabulation=" + this.isHasTabulation() + ", totalsRender=" + String.valueOf(this.getTotalsRender()) + ")";
    }

    public MyTableComposition() {
    }

    public MyTableComposition withHorizontalSplitter(String horizontalSplitter) {
        return this.horizontalSplitter == horizontalSplitter ? this : new MyTableComposition(horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.surround, this.hasTabulation, this.totalsRender);
    }

    public MyTableComposition withBrick(String brick) {
        return this.brick == brick ? this : new MyTableComposition(this.horizontalSplitter, brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.surround, this.hasTabulation, this.totalsRender);
    }

    public MyTableComposition withColumnOrder(ToIntFunction<Map.Entry<String, String>> columnOrder) {
        return this.columnOrder == columnOrder ? this : new MyTableComposition(this.horizontalSplitter, this.brick, columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.surround, this.hasTabulation, this.totalsRender);
    }

    public MyTableComposition withIndents(ToIntFunction<Stream<Map.Entry<String, String>>> indents) {
        return this.indents == indents ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.surround, this.hasTabulation, this.totalsRender);
    }

    public MyTableComposition withHeadingHorizontalBorders(boolean headingHorizontalBorders) {
        return this.headingHorizontalBorders == headingHorizontalBorders ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.surround, this.hasTabulation, this.totalsRender);
    }

    public MyTableComposition withTotalsHorizontalBorders(boolean totalsHorizontalBorders) {
        return this.totalsHorizontalBorders == totalsHorizontalBorders ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, totalsHorizontalBorders, this.needAfterRows, this.surround, this.hasTabulation, this.totalsRender);
    }

    public MyTableComposition withNeedAfterRows(boolean needAfterRows) {
        return this.needAfterRows == needAfterRows ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, needAfterRows, this.surround, this.hasTabulation, this.totalsRender);
    }

    public MyTableComposition withSurround(String surround) {
        return this.surround == surround ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, surround, this.hasTabulation, this.totalsRender);
    }

    public MyTableComposition withHasTabulation(boolean hasTabulation) {
        return this.hasTabulation == hasTabulation ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.surround, hasTabulation, this.totalsRender);
    }

    public MyTableComposition withTotalsRender(Function<Map.Entry<String, String>, String> totalsRender) {
        return this.totalsRender == totalsRender ? this : new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.surround, this.hasTabulation, totalsRender);
    }

    public static class MyTableCompositionBuilder {
        private String horizontalSplitter;
        private String brick;
        private ToIntFunction<Map.Entry<String, String>> columnOrder;
        private ToIntFunction<Stream<Map.Entry<String, String>>> indents;
        private boolean headingHorizontalBorders;
        private boolean totalsHorizontalBorders;
        private boolean needAfterRows;
        private String surround;
        private boolean hasTabulation;
        private Function<Map.Entry<String, String>, String> totalsRender;

        MyTableCompositionBuilder() {
        }

        public MyTableCompositionBuilder horizontalSplitter(String horizontalSplitter) {
            this.horizontalSplitter = horizontalSplitter;
            return this;
        }

        public MyTableCompositionBuilder brick(String brick) {
            this.brick = brick;
            return this;
        }

        public MyTableCompositionBuilder columnOrder(ToIntFunction<Map.Entry<String, String>> columnOrder) {
            this.columnOrder = columnOrder;
            return this;
        }

        public MyTableCompositionBuilder indents(ToIntFunction<Stream<Map.Entry<String, String>>> indents) {
            this.indents = indents;
            return this;
        }

        public MyTableCompositionBuilder headingHorizontalBorders(boolean headingHorizontalBorders) {
            this.headingHorizontalBorders = headingHorizontalBorders;
            return this;
        }

        public MyTableCompositionBuilder totalsHorizontalBorders(boolean totalsHorizontalBorders) {
            this.totalsHorizontalBorders = totalsHorizontalBorders;
            return this;
        }

        public MyTableCompositionBuilder needAfterRows(boolean needAfterRows) {
            this.needAfterRows = needAfterRows;
            return this;
        }

        public MyTableCompositionBuilder surround(String surround) {
            this.surround = surround;
            return this;
        }

        public MyTableCompositionBuilder hasTabulation(boolean hasTabulation) {
            this.hasTabulation = hasTabulation;
            return this;
        }

        public MyTableCompositionBuilder totalsRender(Function<Map.Entry<String, String>, String> totalsRender) {
            this.totalsRender = totalsRender;
            return this;
        }

        public MyTableComposition build() {
            return new MyTableComposition(this.horizontalSplitter, this.brick, this.columnOrder, this.indents, this.headingHorizontalBorders, this.totalsHorizontalBorders, this.needAfterRows, this.surround, this.hasTabulation, this.totalsRender);
        }

        public String toString() {
            return "MyTableComposition.MyTableCompositionBuilder(horizontalSplitter=" + this.horizontalSplitter + ", brick=" + this.brick + ", columnOrder=" + String.valueOf(this.columnOrder) + ", indents=" + String.valueOf(this.indents) + ", headingHorizontalBorders=" + this.headingHorizontalBorders + ", totalsHorizontalBorders=" + this.totalsHorizontalBorders + ", needAfterRows=" + this.needAfterRows + ", surround=" + this.surround + ", hasTabulation=" + this.hasTabulation + ", totalsRender=" + String.valueOf(this.totalsRender) + ")";
        }
    }
}

