/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.GitFS;
import io.github.andreyzebin.gitSql.git.VersionControl;
import io.github.andreyzebin.gitSql.sql.FilePersistedDb;
import io.github.andreyzebin.gitSql.sql.GitSQLDb;
import java.io.Reader;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TimeSeriesQuery
extends FilePersistedDb {
    private static final String COLUMN_NAME_POINT = "point";
    private static final String COLUMN_NAME_HASH = "hash";
    private static final String TABLE_NAME_RESULT = "result";
    private final GitFS dataSet;
    private final GitSQLDb gitDb;
    private final Instant from;
    private final Instant to;
    private final String sql;
    private final List<String> resultAliases = new LinkedList<String>();

    public TimeSeriesQuery(String sql, GitFS dataSet, Instant from, Instant to, Map<Function<String, Boolean>, BiFunction<String, Reader, String>> jsonMappers) {
        super(Path.of("run", "ts_result_cache"));
        this.dataSet = dataSet;
        this.gitDb = new GitSQLDb(dataSet, Path.of("run", "ts_query_cache"), jsonMappers);
        this.from = from;
        this.to = to;
        this.sql = sql;
    }

    @Override
    protected void createSchema() throws SQLException {
    }

    @Override
    protected void reindex() {
        Connection connection = this.getConnection();
        Iterator commitsAll = this.dataSet.commits().collect(Collectors.toList()).reversed().iterator();
        List<Instant> points = TimeSeriesQuery.rangeSplit(this.from, this.to).toList();
        VersionControl.Commit cCommitPrev = (VersionControl.Commit)commitsAll.next();
        VersionControl.Commit cCommitAfter = (VersionControl.Commit)commitsAll.next();
        HashSet<VersionControl.Commit> commits = new HashSet<VersionControl.Commit>();
        for (Instant cPoint : points) {
            long distPrev = TimeSeriesQuery.getMilliDistance(cCommitPrev.getTimestampInstant(), cPoint);
            long distAfter = TimeSeriesQuery.getMilliDistance(cCommitAfter.getTimestampInstant(), cPoint);
            while (distPrev > distAfter && commitsAll.hasNext()) {
                cCommitPrev = cCommitAfter;
                cCommitAfter = (VersionControl.Commit)commitsAll.next();
                distPrev = TimeSeriesQuery.getMilliDistance(cCommitPrev.getTimestampInstant(), cPoint);
                distAfter = TimeSeriesQuery.getMilliDistance(cCommitAfter.getTimestampInstant(), cPoint);
            }
            VersionControl.Commit bestHit = distPrev < distAfter ? cCommitPrev : cCommitAfter;
            if (!commits.add(bestHit)) continue;
            this.pullCommit(bestHit, connection);
        }
    }

    private void pullCommit(VersionControl.Commit cCommitPrev, Connection connection) {
        this.dataSet.seek(cCommitPrev.getHash());
        this.gitDb.drop();
        GitSQLDb.streamRows(rs -> {
            boolean needFillHeader = this.resultAliases.isEmpty();
            if (needFillHeader) {
                this.resultAliases.add(COLUMN_NAME_POINT);
                this.resultAliases.add(COLUMN_NAME_HASH);
            }
            LinkedList<String> row = new LinkedList<String>();
            row.add(cCommitPrev.getTimestampInstant().toString());
            row.add(cCommitPrev.getHash());
            GitSQLDb.streamFields(rs).forEach(cColumn -> {
                if (needFillHeader) {
                    this.resultAliases.add((String)cColumn.getKey());
                }
                row.add((String)cColumn.getValue());
            });
            LinkedList<String> rov = new LinkedList<String>(this.resultAliases);
            rov.addAll(row);
            return rov;
        }, GitSQLDb.query(this.gitDb.getConnection(), this.sql, new String[0])).forEach(cRow -> {
            this.createSchema2();
            GitSQLDb.merge(connection, TABLE_NAME_RESULT, (String[])cRow.toArray(String[]::new));
        });
    }

    private void createSchema2() {
        if (this.schemaCreated) {
            return;
        }
        if (this.storeExists()) {
            try (Statement dml = this.getConnection().createStatement();){
                StringBuilder sql1 = new StringBuilder(String.format("CREATE TABLE IF NOT EXISTS %s\n(\nID INT auto_increment,\n", TABLE_NAME_RESULT));
                for (int i = 0; i < this.resultAliases.size(); ++i) {
                    sql1.append(this.resultAliases.get(i)).append(" VARCHAR(256) ");
                    if (i + 1 < this.resultAliases.size()) {
                        sql1.append(", \n");
                        continue;
                    }
                    sql1.append(" \n");
                }
                sql1.append(");");
                System.out.println(sql1);
                dml.execute(sql1.toString());
                super.createSchema();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Stream<Instant> rangeSplit(Instant from, Instant to) {
        long milliDelta = TimeSeriesQuery.getMilliDelta(from, to);
        int TIME_PIECES = 10;
        long step = milliDelta / 10L;
        return Stream.iterate(from, i -> i.plusMillis(step)).limit(11L);
    }

    private static long getMilliDelta(Instant start, Instant finish) {
        return finish.toEpochMilli() - start.toEpochMilli();
    }

    private static long getMilliDistance(Instant a, Instant b) {
        return Math.abs(TimeSeriesQuery.getMilliDelta(a, b));
    }
}

