/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.GitFS;
import io.github.andreyzebin.gitSql.sql.FilesIndex;
import io.github.andreyzebin.gitSql.sql.PersistedDb;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitsIndex
extends PersistedDb {
    private static final Logger log = LoggerFactory.getLogger(CommitsIndex.class);
    private final GitFS git;

    public CommitsIndex(GitFS git, Path storeDir) {
        super(storeDir);
        this.git = git;
    }

    @Override
    protected void createSchema() throws SQLException {
        try (Statement dml = this.getConnection().createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS commits (ID INT auto_increment, hash VARCHAR(256) NOT NULL, timestamp timestamp NOT NULL, UNIQUE NULLS ALL DISTINCT (hash) );";
            System.out.println("CREATE TABLE IF NOT EXISTS commits (ID INT auto_increment, hash VARCHAR(256) NOT NULL, timestamp timestamp NOT NULL, UNIQUE NULLS ALL DISTINCT (hash) );");
            dml.execute("CREATE TABLE IF NOT EXISTS commits (ID INT auto_increment, hash VARCHAR(256) NOT NULL, timestamp timestamp NOT NULL, UNIQUE NULLS ALL DISTINCT (hash) );");
        }
        super.createSchema();
    }

    @Override
    protected void reindex() {
        try {
            this.git.commits().forEach(cF -> FilesIndex.merge(this.getConnection(), "commits", "hash", "timestamp", cF.getHash(), cF.getTimestamp()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

