/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.bash.BashIO;
import io.github.andreyzebin.gitSql.bash.LogWriter;
import io.github.andreyzebin.gitSql.git.RemoteSource;
import io.github.andreyzebin.gitSql.git.VersionControl;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;

public class GitCommands {
    public static final String ALL_BRANCHES = "";
    public static final String NO_MASTER_COMMITS = GitCommands.notBranch("master");

    public static Optional<String> getBranch(Path repo, BashIO bash, PrintWriter outL, PrintWriter err) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bash.runCommand("git rev-parse --abbrev-ref HEAD", LogWriter.fork(out, outL), err, repo);
        return out.toString().lines().findFirst();
    }

    public static String periodHash(String from, String to) {
        return String.format(" %s..%s ", from, to);
    }

    public static String sinceHash(String from) {
        return GitCommands.periodHash(from, ALL_BRANCHES);
    }

    public static String notBranch(String branch) {
        return String.format("--not %s", branch);
    }

    public static Stream<VersionControl.Change> filesChangedQuery(Path repo, String branch, String query, BashIO bash, PrintWriter outL, PrintWriter err) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bash.runCommand(String.format("git log %s --name-status %s | grep -E '^[A-Z]\\b' | sort -k 2,2 -u", branch, query), LogWriter.fork(out, outL), err, repo);
        return out.toString().lines().map(cBr -> cBr.replaceAll("\\s", ";")).map(cBr -> cBr.replace(";;", ";")).map(cBr -> cBr.replace(";;", ";")).map(cLine -> VersionControl.Change.builder().type(cLine.split(";")[0]).file(cLine.split(";")[1]).build());
    }

    public static void merge(Path repo, String headHash, BashIO bash, PrintWriter outL, PrintWriter err) {
        bash.runCommand(String.format("git merge %s", headHash), outL, err, repo);
    }

    public static void checkout(Path repo, String branch, BashIO bash, PrintWriter outL, PrintWriter err) {
        bash.runCommand(String.format("git checkout -b %s", branch), outL, err, repo);
    }

    public static Stream<RemoteSource.BranchHead> getRemoteBranches(String origin, BashIO bash, PrintWriter outL, PrintWriter err, String authHeader, boolean useSShAgent) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Object sshAgent = useSShAgent ? "ssh-add" + System.lineSeparator() : ALL_BRANCHES;
        bash.runCommand(String.format((String)sshAgent + "git %s ls-remote --heads %s ", authHeader, origin), LogWriter.fork(out, outL), err, Path.of(ALL_BRANCHES, new String[0]));
        return out.toString().lines().map(cBr -> cBr.replaceAll("\\s", ";")).map(cBr -> cBr.replace(";;", ";")).map(cBr -> cBr.replace(";;", ";")).filter(cBr -> cBr.contains("refs/heads/")).map(cBr -> cBr.replace("refs/heads/", ALL_BRANCHES)).map(cBr -> RemoteSource.BranchHead.builder().hash(cBr.split(";")[0]).name(cBr.split(";")[1]).build());
    }

    public static void clone(String target, BashIO bash, PrintWriter out, PrintWriter err, String uri, boolean isQuiet, Path cd, String authHeader, boolean useSShAgent) {
        String props = isQuiet ? " --quiet" : " ";
        Object sshAgent = useSShAgent ? "ssh-add" + System.lineSeparator() : ALL_BRANCHES;
        bash.runCommand((String)sshAgent + "git clone -c core.protectNTFS=false " + authHeader + " " + uri + props + " " + target, out, err, cd);
    }

    public static void clone(String target, BashIO bash, PrintWriter out, PrintWriter err, String uri, boolean isQuiet, Path cd, String authHeader, boolean useSShAgent, String branch) {
        String props = isQuiet ? " --quiet" : " ";
        Object sshAgent = useSShAgent ? "ssh-add" + System.lineSeparator() : ALL_BRANCHES;
        bash.runCommand((String)sshAgent + "git clone -c core.protectNTFS=false --single-branch --branch " + branch + authHeader + " " + uri + props + " " + target, out, err, cd);
    }

    public static void add(Path repo, BashIO bash, Path relative, PrintWriter out, PrintWriter err) {
        bash.runCommand("git add " + Bash.escape(Bash.toPosix(relative)), out, err, repo);
    }

    public static void commit(Path repo, BashIO bash, PrintWriter out, PrintWriter err) {
        bash.runCommand("git commit -a -m \"msg\"", out, err, repo);
    }

    public static void push(Path repo, BashIO bash, PrintWriter out, PrintWriter err, boolean useSShAgent) {
        Object sshAgent = useSShAgent ? "ssh-add" + System.lineSeparator() : ALL_BRANCHES;
        bash.runCommand((String)sshAgent + "git push ", out, err, repo);
    }

    public static void checkout(Path repo, String hash, BashIO bash, PrintWriter out, PrintWriter err, boolean useSShAgent) {
        Object sshAgent = useSShAgent ? "ssh-add" + System.lineSeparator() : ALL_BRANCHES;
        bash.runCommand((String)sshAgent + "git checkout " + hash, out, err, repo);
    }

    public static void pull(Path repo, BashIO bash, PrintWriter out, PrintWriter err, boolean useSShAgent) {
        Object sshAgent = useSShAgent ? "ssh-add" + System.lineSeparator() : ALL_BRANCHES;
        bash.runCommand((String)sshAgent + "git pull", out, err, repo);
    }

    public static Stream<VersionControl.Commit> commitsList(Path repo, BashIO bash, PrintWriter outL, PrintWriter err) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bash.runCommand("git --no-pager log --pretty=%cI,%H ", LogWriter.fork(out, outL), err, repo);
        return out.toString().lines().map(cLine -> VersionControl.Commit.builder().timestamp(cLine.split(",")[0]).hash(cLine.split(",")[1]).build());
    }

    public static Optional<String> getOrigin(Path repo, BashIO bash, PrintWriter outL, PrintWriter err) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bash.runCommand("git config --get remote.origin.url", LogWriter.fork(out, outL), err, repo);
        return out.toString().lines().findFirst();
    }
}

