/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git2;

import io.github.andreyzebin.gitSql.FSOffsetProxy;
import io.github.andreyzebin.gitSql.FileSystem;
import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.git.GitSource;
import io.github.andreyzebin.gitSql.git.VersionControl;
import io.github.andreyzebin.gitSql.git2.GitCommands2;
import io.github.andreyzebin.gitSql.git2.TerminalIO;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitFiles2
implements FileSystem,
VersionControl,
GitSource {
    private static final Logger log = LoggerFactory.getLogger(GitFiles2.class);
    private final boolean isReadOnly;
    private final GitSource source;
    private final TerminalIO term;
    private StringBuffer filesToAdd;
    private Optional<String> origin = null;

    public GitFiles2(boolean isReadOnly, GitSource source, TerminalIO term) {
        this.isReadOnly = isReadOnly;
        this.source = source;
        this.term = term;
        this.filesToAdd = new StringBuffer();
    }

    public GitSource getSource() {
        return this.source;
    }

    @Override
    public Writer put(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Bash.append(this.filesToAdd, path.toString());
            return new FileWriter(newFile.toFile(), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getAbs(Path path) {
        return this.getRoot().resolve(path);
    }

    @Override
    public boolean erase(Path path) {
        if (this.exists(path)) {
            this.term.eval("rm " + Bash.escape(Bash.posix(this.getAbs(path))));
            return true;
        }
        return false;
    }

    @Override
    public Writer patch(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Bash.append(this.filesToAdd, path.toString());
            return new FileWriter(newFile.toFile(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Reader get(Path path) {
        try {
            return new FileReader(this.getAbs(path).toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists(Path path) {
        this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
        return Boolean.parseBoolean(this.term.eval("FILE=" + Bash.escape(Bash.posix(path)) + System.lineSeparator() + "if [ -f \"$FILE\" ]; then\n    echo true \nelse \n    echo false \nfi"));
    }

    @Override
    public boolean isDir(Path path) {
        return this.getAbs(path).toFile().isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String cmd, Consumer<String> stdOut, Consumer<String> stdErr) {
        try {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
            int n = this.term.exec(cmd, stdOut, stdErr);
            return n;
        }
        finally {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String run(String cmd, PrintStream stdOut, PrintStream stdErr, Path path) {
        try {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getAbs(path))));
            String string = String.valueOf(this.term.exec(cmd, stdOut::print, stdErr::print));
            return string;
        }
        finally {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String run(String cmd, PrintWriter stdOut, PrintWriter stdErr, Path path) {
        try {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getAbs(path))));
            String string = String.valueOf(this.term.exec(cmd, stdOut::print, stdErr::print));
            return string;
        }
        finally {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
        }
    }

    @Override
    public void find(Function<Path, Boolean> needContinue, Consumer<Path> sayBye, Comparator<Path> sorting) {
        Path root = this.getRoot();
        FileSystem.tVerse(root, p -> (Boolean)needContinue.apply(root.relativize((Path)p)), p -> sayBye.accept(root.relativize((Path)p)), sorting);
    }

    @Override
    public void flush() {
        if (this.isReadOnly) {
            return;
        }
        if (!this.filesToAdd.toString().isBlank()) {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
            Arrays.stream(this.filesToAdd.toString().split(System.lineSeparator())).forEach(cFile -> GitCommands2.add(this.term, Path.of(cFile, new String[0])));
            GitCommands2.commit(this.term);
            GitCommands2.push(this.term);
        }
        this.filesToAdd = new StringBuffer();
    }

    @Override
    public FileSystem cd(Path jump) {
        return new FSOffsetProxy(this, jump);
    }

    @Override
    public GitFiles2 seek(String commit) {
        this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
        GitCommands2.checkout(commit, this.term);
        return this;
    }

    @Override
    public GitFiles2 pull() {
        this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
        GitCommands2.pull(this.term);
        return this;
    }

    public Stream<VersionControl.Commit> commits() {
        this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
        return GitCommands2.commitsList(this.term);
    }

    @Override
    public Stream<? extends VersionControl.Change> changes(String hashFrom) {
        this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
        return GitCommands2.filesChangedQuery("", GitCommands2.sinceHash(hashFrom), this.term);
    }

    @Override
    public Instant timestamp() {
        this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
        return GitCommands2.commitsList(this.term).findFirst().get().getTimestampInstant();
    }

    @Override
    public void close() throws Exception {
        this.source.close();
    }

    public Optional<String> origin() {
        if (this.origin == null) {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
            this.origin = GitCommands2.getOrigin(this.term);
        }
        return this.origin;
    }

    public Optional<String> branch() {
        this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
        return GitCommands2.getBranch(this.term);
    }

    @Override
    public Path getRoot() {
        return this.source.getRoot();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitFiles2 gitFiles = (GitFiles2)o;
        return Objects.equals(this.source, gitFiles.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }
}

