/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git2;

import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitSource;
import io.github.andreyzebin.gitSql.git.RemoteSource;
import io.github.andreyzebin.gitSql.git2.GitCommands2;
import io.github.andreyzebin.gitSql.git2.TerminalIO;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSource2
implements GitSource {
    private static final Logger log = LoggerFactory.getLogger(RemoteSource2.class);
    private final String gitUri;
    private final TerminalIO bash;
    private final GitAuth authStrategy;
    private Path root;
    private final String branch;

    public RemoteSource2(String gitUri, TerminalIO bash, GitAuth authStrategy) {
        this(gitUri, bash, authStrategy, null);
    }

    public RemoteSource2(String gitUri, TerminalIO bash, GitAuth authStrategy, String branch) {
        this.branch = branch;
        this.gitUri = gitUri;
        this.bash = bash;
        this.authStrategy = authStrategy;
    }

    @Override
    public void close() throws Exception {
        if (this.root != null) {
            if (!this.bash.eval("cd " + Bash.posix(this.root)).isEmpty()) {
                throw new RuntimeException("Could not find root: " + Bash.posix(this.root));
            }
            log.debug("Cleaning up temporary git root...");
            this.bash.eval("cd ../");
            this.bash.eval("rm -rf " + this.root.getFileName().toString());
        }
    }

    public Stream<RemoteSource.BranchHead> listBranches() {
        return GitCommands2.getRemoteBranches(this.gitUri, this.bash, this.authStrategy.getAuthHeader());
    }

    @Override
    public Path getRoot() {
        if (this.root == null) {
            log.debug("Initializing Git root...");
            String rand = UUID.randomUUID().toString().substring(0, 4);
            String[] split = this.gitUri.replace(":", "://").replace("@", URLEncoder.encode("@")).replace(".git", "").split("/");
            String name = split[split.length - 1];
            String tempDirName = name + "_" + rand;
            String pwd = this.bash.eval("pwd");
            try {
                this.bash.eval("mkdir " + tempDirName);
                GitCommands2.clone(tempDirName, this.bash, this.gitUri, false, this.authStrategy.getAuthHeader(), this.branch);
            }
            catch (Exception e) {
                log.error("Error while loading from remote: ", (Throwable)e);
                log.error("Fallback to pwd: {}", (Object)pwd);
                this.bash.eval("cd " + pwd);
                throw new RuntimeException(e);
            }
            Path tmp = Path.of(pwd, new String[0]).resolve(tempDirName);
            if (!tmp.toFile().exists()) {
                throw new RuntimeException("Could not clone remote source: " + this.gitUri);
            }
            this.root = tmp;
        }
        return this.root;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteSource2 that = (RemoteSource2)o;
        return Objects.equals(this.gitUri, that.gitUri) && Objects.equals(this.branch, that.branch);
    }

    public int hashCode() {
        return Objects.hash(this.gitUri, this.branch);
    }
}

