package io.github.andreyzebin.gitSql.git;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

public interface VersionControl {

    @Builder
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    class Commit {

        private String hash;
        private String timestamp;

        @JsonIgnore
        public Instant getTimestampInstant() {
            return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(timestamp));
        }
    }

    @Builder
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    class Change {

        private String file;
        private String type;

        @JsonIgnore
        public boolean isDeletion() {
            return type.equals("D");
        }

        @JsonIgnore
        public boolean isModification() {
            return type.equals("M");
        }

        @JsonIgnore
        public boolean isAddition() {
            return type.equals("A");
        }

        @JsonIgnore
        public boolean isUpdate() {
            return isAddition() || isModification();
        }
    }

    VersionControl seek(String commit);

    Stream<? extends Commit> commits();

    Stream<? extends Change> changes(String hashFrom);

    Instant timestamp();

    void flush();
}
