package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.git2.AbstractVersionControl;
import io.github.andreyzebin.gitSql.git2.GitBindings;
import io.github.andreyzebin.gitSql.git2.TerminalIO;
import java.nio.file.Path;
import java.util.Objects;

public class DirOriginSource extends AbstractVersionControl implements GitSource, GitVersions {

    private final Path root;
    private final GitAuth authStrategy;

    public DirOriginSource(Path root, GitAuth authStrategy, TerminalIO term) {
        super(term);
        this.root = root.toAbsolutePath();
        this.authStrategy = authStrategy;
    }

    @Override
    public Path getRoot() {
        return root;
    }

    @Override
    public void flush() {
        String pwd = term.eval("pwd");
        try {
            term.eval("cd " + Bash.escape(Bash.posix(getRoot())));
            authStrategy.beforeRemote(term);
            GitBindings.push(term);
            authStrategy.afterRemote(term);
        } finally {
            term.eval("cd " + pwd);
        }
    }

    @Override
    public void pull() {
        String pwd = term.eval("pwd");
        try {
            term.eval("cd " + Bash.escape(Bash.posix(getRoot())));
            authStrategy.beforeRemote(term);
            GitBindings.pull(term);
            authStrategy.afterRemote(term);
        } finally {
            term.eval("cd " + pwd);
        }
    }

    @Override
    public void close() throws Exception {

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DirOriginSource that = (DirOriginSource) o;
        return Objects.equals(root, that.root);
    }

    @Override
    public int hashCode() {
        return Objects.hash(root);
    }
}
