package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.git2.GitBindings;
import io.github.andreyzebin.gitSql.git2.TerminalIO;
import java.net.URI;

public interface GitAuth {

    default boolean useAuthHeader() {
        return false;
    }

    default void beforeRemote(TerminalIO terminal) {

    }

    default void afterRemote(TerminalIO terminal) {
    }

    default String injectAuth(String origin) {
        return origin;
    }


    static GitAuth ofSshAgent(String key) {
        return new GitAuth() {

            @Override
            public void beforeRemote(TerminalIO terminal) {
                terminal.eval("eval `ssh-agent`");
                GitBindings.sshAgent(key, terminal);
            }

        };
    }

    static GitAuth userAndToken(String username, String token) {
        return new GitAuth() {

            @Override
            public void beforeRemote(TerminalIO terminal) {
                terminal.secret("GIT_USERNAME", username);
                terminal.secret("GIT_TOKEN", token);
            }

            @Override
            public String injectAuth(String origin) {
                final URI uri = URI.create(origin);
                return URI.create(uri.getScheme() + "://" + "$GIT_USERNAME" + ":" + "$GIT_TOKEN" + "@"
                        + uri.getRawAuthority()
                        + uri.getRawPath()).toString();
            }
        };
    }

    static GitAuth ofApiToken(String token) {
        return new GitAuth() {
            @Override
            public boolean useAuthHeader() {
                return true;
            }

            @Override
            public void beforeRemote(TerminalIO terminal) {
                terminal.secret("API_TOKEN", token);
            }
        };
    }
}
