package io.github.andreyzebin.gitSql.git2;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Terminal implements TerminalIO {

    private final Process process;
    private final byte[] buffer = new byte[4000];
    private final PrintWriter pw;
    private final String fin = UUID.randomUUID().toString().substring(0, 8);

    public Terminal(Process process) {
        this.process = process;
        pw = new PrintWriter(process.getOutputStream());
        pw.println(String.format("fu=%s ; fu+=%s ; echo $fu", fin.substring(0, 4), fin.substring(4, 8)));
        execute(process, buffer, fin, (ff) -> {
        }, (ff) -> {
        });
    }

    public int exec(String comm, Consumer<String> stdout, Consumer<String> stderr) {
        return exec(comm, comm, stdout, stderr);
    }

    @Override
    public int exec(String comm, String mask, Consumer<String> stdout, Consumer<String> stderr) {
        StringBuilder ret = new StringBuilder();
        StringBuilder err = new StringBuilder();

        pw.println(comm);
        pw.println("return=$?");
        pw.println("echo $fu");
        execute(process, buffer, fin, stdout, stderr);
        pw.println("echo $return");
        pw.println("echo $fu");

        execute(process, buffer, fin, ret::append, err::append);
        return Integer.parseInt(ret.toString().lines().collect(Collectors.joining()));
    }

    private void execute(Process process, byte[] buffer, String fin, Consumer<String> wr, Consumer<String> stderr) {
        pw.flush();
        InputStream out = process.getInputStream();
        InputStream err = process.getErrorStream();
        // wait $fu$
        int matched = 0;
        boolean isFinished = false;
        try {
            while (isAlive(process) && !isFinished) {
                matched = pull(buffer, fin, wr, out, matched);
                pullErr(buffer, stderr, err);
                if (matched == fin.length()) {
                    // eof
                    isFinished = true;
                }

                try {
                    Thread.sleep(10);
                } catch (InterruptedException e) {
                }
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int pull(byte[] buffer, String fin, Consumer<String> wr, InputStream out, int matched)
            throws IOException {
        int no = out.available();
        if (no > 0) {
            int n = out.read(buffer, 0, Math.min(no, buffer.length));
            String bufSeg = new String(buffer, 0, n);
            for (int i = 0; i < bufSeg.length(); i++) {
                char toFind = fin.charAt(matched);
                char cChar = bufSeg.charAt(i);
                if (toFind == cChar) {
                    matched++;
                    if (matched == fin.length()) {
                        break;
                    }
                } else {
                    wr.accept(fin.substring(0, matched));
                    wr.accept(String.valueOf(cChar));
                    matched = 0;
                }
            }
        }
        return matched;
    }

    private static void pullErr(byte[] buffer, Consumer<String> wr, InputStream out)
            throws IOException {
        int no = out.available();
        if (no > 0) {
            int n = out.read(buffer, 0, Math.min(no, buffer.length));
            String bufSeg = new String(buffer, 0, n);
            wr.accept(bufSeg);
        }
    }

    private boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        } catch (IllegalThreadStateException e) {
            return true;
        }
    }

}