/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.pretty;

import io.github.andreyzebin.gitSql.pretty.TableComposition;
import io.github.andreyzebin.gitSql.pretty.TableStreamRow;
import io.github.andreyzebin.gitSql.sql.SqlUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TablePrinter {
    private final TableComposition composition;
    private final String query;
    private final Map<String, BiFunction<Integer, Map<String, Optional<String>>, Integer>> aggregates;
    private final Map<String, AtomicInteger> totals = new HashMap<String, AtomicInteger>();
    private TableStreamRow last;
    private Map<String, String> headers;
    private boolean headerPrinted = false;

    public TablePrinter(TableComposition composition, String query, Map<String, BiFunction<Integer, Map<String, Optional<String>>, Integer>> aggregates) {
        this.composition = composition;
        this.query = query;
        this.aggregates = aggregates;
    }

    public static <K, V> Map<K, V> combine(Map<K, V> row, Map<K, V> collect) {
        HashMap<K, V> rowWithTotala = new HashMap<K, V>(row);
        rowWithTotala.putAll(collect);
        return rowWithTotala;
    }

    public Stream<String> lines(Connection connection) {
        LinkedList<String> strings = new LinkedList<String>();
        SqlUtils.streamRows(rs -> this.row(SqlUtils.streamFields(rs)), SqlUtils.query(connection, this.query, new String[0])).forEach(this.composition.getRowConsumer(strings));
        this.composition.getAfterRows(this, strings);
        return strings.stream();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public TableStreamRow row(Stream<Map.Entry<String, String>> row) {
        TableStreamRow build;
        Map<String, Optional<String>> columns = row.collect(Collectors.toMap(Map.Entry::getKey, v -> Optional.ofNullable((String)v.getValue())));
        if (this.headers == null) {
            this.headers = columns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getKey));
        }
        this.aggregates.keySet().forEach(cVal -> {
            AtomicInteger metrica = this.totals.computeIfAbsent((String)cVal, k -> new AtomicInteger());
            BiFunction<Integer, Map<String, Optional<String>>, Integer> aggregator = this.aggregates.get(cVal);
            metrica.set(aggregator.apply(metrica.get(), columns));
        });
        this.last = build = TableStreamRow.builder().table(this).row(columns).totals(this.totals.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ce -> ((AtomicInteger)ce.getValue()).get()))).build();
        return build;
    }

    public boolean isHeaderPrinted() {
        return this.headerPrinted;
    }

    public void setHeaderPrinted(boolean headerPrinted) {
        this.headerPrinted = headerPrinted;
    }

    public TableStreamRow getLast() {
        return this.last;
    }
}

