/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.sql.JdbcView;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistedIndex
implements JdbcView {
    private static final Logger log = LoggerFactory.getLogger(PersistedIndex.class);
    private final Path storeDir;
    private Connection connection;
    protected Path lastStore;
    protected boolean schemaCreated = false;

    public PersistedIndex(Path storeDir) {
        this.storeDir = storeDir.toAbsolutePath();
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            log.info("Initializing DB store: {}", (Object)this.storeDir);
            Files.createDirectories(this.storeDir, new FileAttribute[0]);
            boolean justCreated = !this.storeExists();
            String jdbcURL = "jdbc:h2:" + this.storeDir.resolve("data");
            this.connection = DriverManager.getConnection(jdbcURL, "", "");
            log.info("Connected to H2 embedded database.");
            if (justCreated) {
                this.createSchema();
                this.reindex();
            } else {
                this.init();
            }
            return this.connection;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean storeExists() {
        this.lastStore = this.lastStore == null ? this.storeDir.resolve("data.mv.db") : this.lastStore;
        return Files.exists(this.lastStore, new LinkOption[0]);
    }

    protected void createSchema() throws SQLException {
        if (this.storeExists()) {
            this.schemaCreated = true;
        }
    }

    protected void init() {
    }

    protected void reindex() {
    }

    @Override
    public PersistedIndex drop() {
        try {
            this.connection = null;
            if (this.storeExists()) {
                Files.deleteIfExists(this.lastStore);
                this.schemaCreated = false;
                log.info("Deleted DB store file: {}", (Object)this.lastStore);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

