/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.git2.GitBindings;
import io.github.andreyzebin.gitSql.git2.TerminalIO;
import java.net.URI;

public interface GitAuth {
    default public boolean useAuthHeader() {
        return false;
    }

    default public void beforeRemote(TerminalIO terminal) {
    }

    default public void afterRemote(TerminalIO terminal) {
    }

    default public String injectAuth(String origin) {
        return origin;
    }

    public static GitAuth ofSshAgent(final String key) {
        return new GitAuth(){

            @Override
            public void beforeRemote(TerminalIO terminal) {
                terminal.eval("eval `ssh-agent`");
                GitBindings.sshAgent(key, terminal);
            }
        };
    }

    public static GitAuth userAndToken(final String username, final String token) {
        return new GitAuth(){

            @Override
            public void beforeRemote(TerminalIO terminal) {
                terminal.secret("GIT_USERNAME", username);
                terminal.secret("GIT_TOKEN", token);
            }

            @Override
            public String injectAuth(String origin) {
                URI uri = URI.create(origin);
                return URI.create(uri.getScheme() + "://$GIT_USERNAME:$GIT_TOKEN@" + uri.getRawAuthority() + uri.getRawPath()).toString();
            }
        };
    }

    public static GitAuth ofApiToken(final String token) {
        return new GitAuth(){

            @Override
            public boolean useAuthHeader() {
                return true;
            }

            @Override
            public void beforeRemote(TerminalIO terminal) {
                terminal.secret("API_TOKEN", token);
            }
        };
    }
}

