/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git2;

import io.github.andreyzebin.gitSql.git2.TerminalFun;
import io.github.andreyzebin.gitSql.git2.TerminalIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Terminal
implements TerminalIO {
    private final Process process;
    private final byte[] buffer = new byte[4000];
    private final PrintWriter pw;
    private final String fin = UUID.randomUUID().toString().substring(0, 8);

    public Terminal(Process process) {
        this.process = process;
        this.pw = new PrintWriter(process.getOutputStream());
        this.pw.println(String.format("fu=%s ; fu+=%s ; echo $fu", this.fin.substring(0, 4), this.fin.substring(4, 8)));
        this.execute(process, this.buffer, this.fin, ff -> {}, ff -> {});
    }

    @Override
    public int exec(String comm, Consumer<String> stdout, Consumer<String> stderr) {
        return this.exec(comm, comm, stdout, stderr);
    }

    @Override
    public int exec(String comm, String mask, Consumer<String> stdout, Consumer<String> stderr) {
        StringBuilder ret = new StringBuilder();
        StringBuilder err = new StringBuilder();
        this.pw.println(comm);
        this.pw.println("return=$?");
        this.pw.println("echo $fu");
        this.execute(this.process, this.buffer, this.fin, stdout, stderr);
        this.pw.println("echo $return");
        this.pw.println("echo $fu");
        this.execute(this.process, this.buffer, this.fin, ret::append, err::append);
        return Integer.parseInt(ret.toString().lines().collect(Collectors.joining()));
    }

    private void execute(Process process, byte[] buffer, String fin, Consumer<String> wr, Consumer<String> stderr) {
        this.pw.flush();
        InputStream out = process.getInputStream();
        InputStream err = process.getErrorStream();
        AtomicBoolean writtenOut = new AtomicBoolean();
        AtomicBoolean writtenErr = new AtomicBoolean();
        int matched = 0;
        boolean isFinished = false;
        try {
            while (this.isAlive(process) && !isFinished) {
                writtenOut.set(true);
                writtenErr.set(true);
                while (writtenOut.get() || writtenErr.get()) {
                    writtenOut.set(false);
                    writtenErr.set(false);
                    matched = Terminal.pull(buffer, fin, TerminalFun.fork(wr, fu -> writtenOut.set(true)), out, matched);
                    Terminal.pullErr(buffer, TerminalFun.fork(stderr, fu -> writtenErr.set(true)), err);
                    if (matched != fin.length()) continue;
                    isFinished = true;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int pull(byte[] buffer, String fin, Consumer<String> wr, InputStream out, int matched) throws IOException {
        int no = out.available();
        if (no > 0) {
            int n = out.read(buffer, 0, Math.min(no, buffer.length));
            String bufSeg = new String(buffer, 0, n);
            for (int i = 0; i < bufSeg.length(); ++i) {
                char cChar;
                char toFind = fin.charAt(matched);
                if (toFind == (cChar = bufSeg.charAt(i))) {
                    if (++matched != fin.length()) continue;
                    break;
                }
                wr.accept(fin.substring(0, matched));
                wr.accept(String.valueOf(cChar));
                matched = 0;
            }
        }
        return matched;
    }

    private static void pullErr(byte[] buffer, Consumer<String> wr, InputStream out) throws IOException {
        int no = out.available();
        if (no > 0) {
            int n = out.read(buffer, 0, Math.min(no, buffer.length));
            String bufSeg = new String(buffer, 0, n);
            wr.accept(bufSeg);
        }
    }

    private boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }
}

