/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git2;

import io.github.andreyzebin.gitSql.FSOffsetProxy;
import io.github.andreyzebin.gitSql.FileSystem;
import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.git.GitVersions;
import io.github.andreyzebin.gitSql.git2.GitBindings;
import io.github.andreyzebin.gitSql.git2.TerminalIO;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedFiles
implements FileSystem {
    private static final Logger log = LoggerFactory.getLogger(VersionedFiles.class);
    private final boolean isReadOnly;
    private final GitVersions source;
    private final TerminalIO term;
    private StringBuffer filesToAdd;

    public VersionedFiles(boolean isReadOnly, GitVersions source, TerminalIO term) {
        this.isReadOnly = isReadOnly;
        this.source = source;
        this.term = term;
        this.filesToAdd = new StringBuffer();
    }

    public GitVersions getSource() {
        return this.source;
    }

    @Override
    public Writer put(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Bash.append(this.filesToAdd, path.toString());
            return new FileWriter(newFile.toFile(), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getAbs(Path path) {
        return this.getRoot().resolve(path);
    }

    @Override
    public boolean erase(Path path) {
        if (this.exists(path)) {
            this.term.eval("rm " + Bash.escape(Bash.posix(this.getAbs(path))));
            return true;
        }
        return false;
    }

    @Override
    public Writer patch(Path path) {
        try {
            Path newFile = this.getAbs(path);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Bash.append(this.filesToAdd, path.toString());
            return new FileWriter(newFile.toFile(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Reader get(Path path) {
        try {
            return new FileReader(this.getAbs(path).toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists(Path path) {
        return Files.exists(this.getAbs(path), new LinkOption[0]);
    }

    @Override
    public boolean isDir(Path path) {
        return this.getAbs(path).toFile().isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String cmd, Consumer<String> stdOut, Consumer<String> stdErr) {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + Bash.escape(Bash.posix(this.getAbs(Path.of("", new String[0])))));
            int n = this.term.exec(cmd, stdOut, stdErr);
            return n;
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void find(Function<Path, Boolean> needContinue, Consumer<Path> sayBye, Comparator<Path> sorting) {
        Path root = this.getRoot();
        FileSystem.tVerse(root, p -> (Boolean)needContinue.apply(root.relativize((Path)p)), p -> sayBye.accept(root.relativize((Path)p)), sorting);
    }

    @Override
    public void flush() {
        if (this.isReadOnly) {
            return;
        }
        if (!this.filesToAdd.toString().isBlank()) {
            String pwd = this.term.eval("pwd");
            try {
                this.term.eval("cd " + Bash.escape(Bash.posix(this.getRoot())));
                Arrays.stream(this.filesToAdd.toString().split(System.lineSeparator())).forEach(cFile -> GitBindings.add(this.term, Path.of(cFile, new String[0])));
                if (GitBindings.hasStatus(this.term)) {
                    GitBindings.commit(this.term);
                    this.term.eval("cd ..");
                    this.source.flush();
                } else {
                    log.debug("Status has no changes, skip commit.");
                }
            }
            finally {
                this.term.eval("cd " + pwd);
            }
        }
        this.filesToAdd = new StringBuffer();
    }

    @Override
    public FileSystem cd(Path jump) {
        return new FSOffsetProxy(this, jump);
    }

    @Override
    public void close() throws Exception {
        this.source.close();
    }

    public Path getRoot() {
        return this.source.getRoot();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedFiles gitFiles = (VersionedFiles)o;
        return Objects.equals(this.source, gitFiles.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }
}

