/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git2;

import java.util.function.Consumer;
import java.util.stream.Collectors;

public interface TerminalIO {
    public void setTimeoutMillis(long var1);

    public int exec(String var1, String var2, Consumer<String> var3, Consumer<String> var4);

    default public int exec(String comm, Consumer<String> stdout, Consumer<String> stderr) {
        return this.exec(comm, comm, stdout, stderr);
    }

    default public String eval(String comm) {
        StringBuilder stringBuilder = new StringBuilder();
        int exec = this.exec(comm, stringBuilder::append, stringBuilder::append);
        if (exec != 0) {
            throw new RuntimeException(String.format("Could not evaluate '%s', returned non-zero: " + exec, comm));
        }
        return stringBuilder.toString().lines().collect(Collectors.joining(System.lineSeparator()));
    }

    default public String eval(String comm, String mask) {
        StringBuilder stringBuilder = new StringBuilder();
        int exec = this.exec(comm, mask, stringBuilder::append, stringBuilder::append);
        if (exec != 0) {
            throw new RuntimeException(String.format("Could not evaluate '%s', returned non-zero: " + exec, mask));
        }
        return stringBuilder.toString().lines().collect(Collectors.joining(System.lineSeparator()));
    }

    default public void secret(String key, String value) {
        this.eval(String.format("%s=%s", key, value), String.format("%s=***", key));
    }
}

