package io.github.andreyzebin.gitSql.bash;

public class BashCSS {

    public static String bashRender(String cmd) {
        return bashHighlights(new BashTML(cmd)).toString();
    }

    public static BashTML bashHighlights(BashTML bashTML) {
        for (String f : new String[]{
                "mkdir",
                "pwd",
                "rm -rf",
                "rm",
                "ssh-add",
                "cd ",
                "git clone",
                "git checkout",
                "git add",
                "git push",
                "git commit",
                "git "}
        ) {
            bashTML.paint(f, Color.YELLOW_BOLD);
        }

        bashTML.fillSurrounding("\"", Color.MAGENTA);

        for (String f : new String[]{
                "\""}
        ) {
            bashTML.paint(f, Color.RED_BRIGHT);
        }

        for (String f : new String[]{
                "false",
                "true"}
        ) {
            bashTML.paint(f, Color.GREEN_BRIGHT);
        }

        return bashTML;
    }

    public static BashTML stdRender(BashTML bashTML) {
        return bashTML.fill(Color.GREEN);
    }

    public static BashTML stdErrRender(BashTML bashTML) {
        return bashTML
                .fill(Color.RED)
                .paint("ERROR", Color.RED_BOLD_BRIGHT)
                .paint("FAIL", Color.RED_BOLD_BRIGHT);
    }
}
