package io.github.andreyzebin.gitSql.bash;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.function.Consumer;

public class BashV2 {

    private final Process process;
    private final byte[] buffer = new byte[4000];
    private final PrintWriter pw;
    private final String fin = "FIN";

    public BashV2(Process process) {
        this.process = process;
        pw = new PrintWriter(process.getOutputStream());
        pw.println("fu=F ; fu+=IN");
        execute(process, buffer, fin, (ff) -> {
        });
    }

    public void exec(String comm, Consumer<String> print) {
        pw.println(comm);
        pw.println("echo $fu");
        pw.flush();
        execute(process, buffer, fin, print);
    }

    private void execute(Process process, byte[] buffer, String fin, Consumer<String> wr) {
        InputStream out = process.getInputStream();
        // wait $fu$
        int matched = 0;
        boolean isFinished = false;
        try {
            while (isAlive(process) && !isFinished) {
                int no = 0;
                no = out.available();
                if (no > 0) {
                    int n = out.read(buffer, 0, Math.min(no, buffer.length));
                    final String bufSeg = new String(buffer, 0, n);
                    for (int i = 0; i < n - 1; i++) {
                        char toFind = fin.charAt(matched);
                        final char cChar = bufSeg.charAt(i);
                        if (toFind == cChar) {
                            matched++;
                            if (matched == fin.length()) {
                                // eof
                                isFinished = true;
                                break;
                            }
                        } else {
                            wr.accept(fin.substring(0, matched));
                            wr.accept(String.valueOf(cChar));
                            matched = 0;
                        }
                    }
                }

                try {
                    Thread.sleep(10);
                } catch (InterruptedException e) {
                }
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        } catch (IllegalThreadStateException e) {
            return true;
        }
    }

}
