package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.bash.BashTML;
import io.github.andreyzebin.gitSql.bash.Color;
import lombok.Builder;
import lombok.Data;
import lombok.With;

@Data
@Builder
@With
public class SqlCSS {

    public static String sqlRender(String cmd) {
        return sqlHighlights(new BashTML(cmd)).toString();
    }

    public static BashTML sqlHighlights(BashTML bashTML) {
        for (String f : new String[]{
                "SELECT",
                "FROM",
                "WHERE",
                "MERGE",
                "USING",
                "ON ",
                "WHEN",
                "INSERT",
                "UPDATE",
                "SET",
                "CREATE",
                "TABLE",
                "then"
        }
        ) {
            bashTML.paint(f, Color.YELLOW_BOLD_BRIGHT);
        }

        for (String f : new String[]{
                "NOT",
                "not"
        }
        ) {
            bashTML.paint(f, Color.RED);
        }

        for (String f : new String[]{
                "NULL"
        }
        ) {
            bashTML.paint(f, Color.GREEN_BOLD_BRIGHT);
        }

        for (String f : new String[]{
                "matched"
        }
        ) {
            bashTML.paint(f, Color.WHITE_BOLD_BRIGHT);
        }

        for (String f : new String[]{
                "\""}
        ) {
            bashTML.fillSurrounding(f, Color.MAGENTA);
        }

        for (String f : new String[]{
                "\""}
        ) {
            bashTML.paint(f, Color.RED);
        }

        for (String f : new String[]{
                "'"}
        ) {
            bashTML.fillSurrounding(f, Color.GREEN);
        }

        for (String f : new String[]{
                "'"}
        ) {
            bashTML.paint(f, Color.RED);
        }
        return bashTML;
    }
}
