/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git2;

import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.git.BranchHead;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitSource;
import io.github.andreyzebin.gitSql.git.GitVersions;
import io.github.andreyzebin.gitSql.git2.AbstractVersionControl;
import io.github.andreyzebin.gitSql.git2.DefaultConfigurations;
import io.github.andreyzebin.gitSql.git2.GitBindings;
import io.github.andreyzebin.gitSql.git2.GitConfigurations;
import io.github.andreyzebin.gitSql.git2.TerminalIO;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteOrigin
extends AbstractVersionControl
implements GitSource,
GitVersions {
    private static final Logger log = LoggerFactory.getLogger(RemoteOrigin.class);
    protected String gitUri;
    private final TerminalIO bash;
    private final GitAuth authStrategy;
    protected Path root;
    private final String branch;
    private final Path home;
    private final GitConfigurations configurations;

    public RemoteOrigin(String gitUri, TerminalIO bash, GitAuth authStrategy) {
        this(gitUri, bash, authStrategy, null, new DefaultConfigurations(bash));
    }

    public RemoteOrigin(String gitUri, TerminalIO bash, GitAuth authStrategy, String branch) {
        this(gitUri, bash, authStrategy, branch, new DefaultConfigurations(bash));
    }

    public RemoteOrigin(String gitUri, TerminalIO bash, GitAuth authStrategy, String branch, GitConfigurations configurations) {
        super(bash);
        this.branch = branch;
        this.gitUri = gitUri;
        this.bash = bash;
        this.authStrategy = authStrategy;
        this.home = configurations.getHomeTemporaryDir();
        this.configurations = configurations;
    }

    @Override
    public void close() throws Exception {
        if (this.root != null) {
            TerminalIO.transactionalDir(this.bash, () -> {
                log.debug("Cleaning up temporary git root...");
                this.bash.eval("cd " + Bash.encode(this.root.getParent()));
                this.bash.eval("rm -rf " + this.root.getFileName().toString());
            });
        }
    }

    public Stream<BranchHead> listBranches() {
        this.authStrategy.beforeRemote(this.bash);
        Stream<BranchHead> remoteBranches = GitBindings.getRemoteBranches(this.authStrategy.injectAuth(this.gitUri), this.bash, this.authStrategy.useAuthHeader());
        this.authStrategy.afterRemote(this.bash);
        return remoteBranches;
    }

    @Override
    public Path getRoot() {
        if (this.root == null) {
            log.debug("Initializing Git root...");
            return TerminalIO.transactionalDir(this.bash, () -> {
                String tempDirName = this.configurations.getTemporaryName(this.gitUri, this.branch);
                try {
                    this.bash.eval("cd " + Bash.encode(this.home));
                    this.bash.eval("mkdir -p " + tempDirName);
                    this.bash.eval("cd " + tempDirName);
                    this.authStrategy.beforeRemote(this.bash);
                    GitBindings.clone(".", this.bash, this.authStrategy.injectAuth(this.gitUri), false, this.authStrategy.useAuthHeader(), this.branch);
                    this.authStrategy.afterRemote(this.bash);
                    this.root = this.home.resolve(tempDirName);
                    return this.root;
                }
                catch (Exception e) {
                    log.error("Error while loading from remote: ", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        return this.root;
    }

    @Override
    public void flush() {
        if (this.root != null) {
            TerminalIO.transactionalDir(this.bash, () -> {
                this.bash.eval("cd " + Bash.encode(this.getRoot()));
                this.authStrategy.beforeRemote(this.bash);
                GitBindings.push(this.bash);
                this.authStrategy.afterRemote(this.bash);
            });
        }
    }

    @Override
    public void pull() {
        TerminalIO.transactionalDir(this.bash, () -> {
            this.bash.eval("cd " + Bash.encode(this.getRoot()));
            this.authStrategy.beforeRemote(this.bash);
            GitBindings.pull(this.bash);
            this.authStrategy.afterRemote(this.bash);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteOrigin that = (RemoteOrigin)o;
        return Objects.equals(this.gitUri, that.gitUri) && Objects.equals(this.branch, that.branch);
    }

    public int hashCode() {
        return Objects.hash(this.gitUri, this.branch);
    }
}

