/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql;

import io.github.andreyzebin.gitSql.FileSystem;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;

public class FSOffsetProxy
implements FileSystem {
    private final FileSystem delegate;
    private final Path offset;

    public FSOffsetProxy(FileSystem delegate, Path offset) {
        this.delegate = delegate;
        this.offset = offset;
    }

    private Path toDelegate(Path rel) {
        return this.offset.resolve(rel);
    }

    private Path toProxy(Path delegateBy) {
        return this.offset.relativize(delegateBy);
    }

    @Override
    public Writer put(Path path) {
        return this.delegate.put(this.toDelegate(path));
    }

    @Override
    public boolean erase(Path path) {
        return this.delegate.erase(this.toDelegate(path));
    }

    @Override
    public Writer patch(Path path) {
        return this.delegate.patch(this.toDelegate(path));
    }

    @Override
    public Reader get(Path path) {
        return this.delegate.get(this.toDelegate(path));
    }

    @Override
    public boolean exists(Path path) {
        return this.delegate.exists(this.toDelegate(path));
    }

    @Override
    public boolean isDir(Path path) {
        return this.delegate.isDir(this.toDelegate(path));
    }

    @Override
    public int run(String cmd, Consumer<String> stdOut, Consumer<String> stdErr) {
        return this.delegate.run(cmd, stdOut, stdErr);
    }

    @Override
    public void find(Function<Path, Boolean> needContinue, Consumer<Path> sayBye, Comparator<Path> sorting) {
        this.delegate.find(p -> (Boolean)needContinue.apply(this.toProxy((Path)p)), p -> sayBye.accept(this.toProxy((Path)p)), sorting);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public FileSystem cd(Path jump) {
        throw new RuntimeException("Unsupported!");
    }

    @Override
    public void close() throws Exception {
    }
}

