/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.bash;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PosixPath
implements Iterable<PosixPath> {
    private final String[] segments;
    private final int start;
    private final int end;

    private PosixPath(int start, int end, String ... segments) {
        this.segments = segments;
        this.start = start;
        this.end = end;
    }

    public Path toRelativePath() {
        return this.end - this.start > 0 ? Path.of("", this.segments).subpath(this.start, this.end) : Path.of("", new String[0]);
    }

    public int length() {
        return this.end - this.start;
    }

    public String toString() {
        return StreamSupport.stream(Arrays.spliterator(this.segments, this.start, this.end), false).collect(Collectors.joining("/"));
    }

    @Override
    public Iterator<PosixPath> iterator() {
        return new Iterator<PosixPath>(){
            private PosixPath it;
            {
                this.it = PosixPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.it != null;
            }

            @Override
            public PosixPath next() {
                PosixPath it1 = this.it;
                this.it = it1.hasMore() ? it1.descend() : null;
                return it1;
            }
        };
    }

    public static PosixPath of(String ... segments) {
        return new PosixPath(0, segments.length, segments);
    }

    public PosixPath descend() {
        return new PosixPath(this.start, this.end - 1, this.segments);
    }

    public PosixPath climb(PosixPath suffix) {
        String[] dest = new String[this.length() + suffix.length()];
        System.arraycopy(this.segments, this.start, dest, 0, this.length());
        System.arraycopy(suffix.segments, suffix.start, dest, this.length(), suffix.length());
        return PosixPath.of(dest);
    }

    public boolean hasMore() {
        return this.start < this.end;
    }

    public boolean isRoot() {
        return !this.hasMore();
    }

    public Stream<PosixPath> descendStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PosixPath posixPath = (PosixPath)o;
        return Arrays.equals(posixPath.segments, posixPath.start, posixPath.end, this.segments, this.start, this.end);
    }

    public int hashCode() {
        return PosixPath.arrayHashCode(this.segments, this.start, this.end);
    }

    public static int arrayHashCode(Object[] a, int start, int end) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = start; i < end; ++i) {
            Object element = a[i];
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }
}

