/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.git;

import io.github.andreyzebin.gitSql.bash.Bash;
import io.github.andreyzebin.gitSql.git.GitAuth;
import io.github.andreyzebin.gitSql.git.GitVersions;
import io.github.andreyzebin.gitSql.git2.AbstractVersionControl;
import io.github.andreyzebin.gitSql.git2.GitBindings;
import io.github.andreyzebin.gitSql.git2.TerminalIO;
import java.nio.file.Path;
import java.util.Objects;

public class DirOriginSource
extends AbstractVersionControl
implements GitVersions {
    private final Path root;
    private final GitAuth authStrategy;

    public DirOriginSource(Path root, GitAuth authStrategy, TerminalIO term) {
        super(term);
        this.root = root.toAbsolutePath();
        this.authStrategy = authStrategy;
    }

    @Override
    public Path getRoot() {
        return this.root;
    }

    @Override
    public void flush() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + Bash.encode(this.getRoot()));
            this.authStrategy.beforeRemote(this.term);
            GitBindings.push(this.term);
            this.authStrategy.afterRemote(this.term);
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void pull() {
        String pwd = this.term.eval("pwd");
        try {
            this.term.eval("cd " + Bash.encode(this.getRoot()));
            this.authStrategy.beforeRemote(this.term);
            GitBindings.pull(this.term);
            this.authStrategy.afterRemote(this.term);
        }
        finally {
            this.term.eval("cd " + pwd);
        }
    }

    @Override
    public void close() throws Exception {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirOriginSource that = (DirOriginSource)o;
        return Objects.equals(this.root, that.root);
    }

    public int hashCode() {
        return Objects.hash(this.root);
    }
}

