/*
 * Decompiled with CFR 0.152.
 */
package io.github.andreyzebin.gitSql.sql;

import io.github.andreyzebin.gitSql.git.VersionControl;
import io.github.andreyzebin.gitSql.git.VersionedFiles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GitUtils {
    public static <E> List<E> reversed(List<E> col) {
        ArrayList<E> es = new ArrayList<E>(col);
        Collections.reverse(es);
        return es;
    }

    public static Stream<VersionControl.Commit> getPoints(VersionedFiles cDataSet, Instant from1, Instant to1) {
        LinkedList<VersionControl.Commit> foundPoints = new LinkedList<VersionControl.Commit>();
        Iterator commitsAll = GitUtils.reversed(cDataSet.getSource().commits().collect(Collectors.toList())).iterator();
        List<Instant> points = GitUtils.rangeSplit(from1, to1).toList();
        VersionControl.Commit cCommitPrev = (VersionControl.Commit)commitsAll.next();
        VersionControl.Commit cCommitAfter = (VersionControl.Commit)commitsAll.next();
        HashSet<VersionControl.Commit> commits = new HashSet<VersionControl.Commit>();
        for (Instant cPoint : points) {
            long distPrev = GitUtils.getMilliDistance(cCommitPrev.getTimestampInstant(), cPoint);
            long distAfter = GitUtils.getMilliDistance(cCommitAfter.getTimestampInstant(), cPoint);
            while (distPrev > distAfter && commitsAll.hasNext()) {
                cCommitPrev = cCommitAfter;
                cCommitAfter = (VersionControl.Commit)commitsAll.next();
                distPrev = GitUtils.getMilliDistance(cCommitPrev.getTimestampInstant(), cPoint);
                distAfter = GitUtils.getMilliDistance(cCommitAfter.getTimestampInstant(), cPoint);
            }
            VersionControl.Commit bestHit = distPrev < distAfter ? cCommitPrev : cCommitAfter;
            if (!commits.add(bestHit)) continue;
            foundPoints.add(bestHit);
        }
        return foundPoints.stream();
    }

    static long getMilliDelta(Instant start, Instant finish) {
        return finish.toEpochMilli() - start.toEpochMilli();
    }

    private static long getMilliDistance(Instant a, Instant b) {
        return Math.abs(GitUtils.getMilliDelta(a, b));
    }

    public static Stream<Instant> rangeSplit(Instant from, Instant to) {
        long milliDelta = GitUtils.getMilliDelta(from, to);
        int TIME_PIECES = 10;
        long step = milliDelta / 10L;
        return Stream.iterate(from, i -> i.plusMillis(step)).limit(11L);
    }
}

